---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：113-Parent-Join

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **多階層対応の詳細仕様**：実装コードの詳細確認が必要
  2. **ルーティング制約の詳細**：ドキュメント登録時の制約確認

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/parent-join/src/main/java/org/opensearch/join/ParentJoinModulePlugin.java`
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.113）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ParentJoinModulePluginがSearchPluginとMapperPluginを実装 | E-01 (53行目) | ○ |
| C-02 | has_child、has_parent、parent_idの3クエリを登録 | E-01 (58-64行目) | ○ |
| C-03 | children、parentの2集計を登録 | E-01 (67-74行目) | ○ |
| C-04 | ParentJoinFieldMapperをjoinタイプとして登録 | E-01 (77-79行目) | ○ |
| C-05 | InternalChildrenとInternalParentが結果リーダー | E-01 (70, 73行目) | ○ |
| C-06 | 機能No.113がParent-Join | E-02 | ○ |
| C-07 | 画面機能マッピングに直接対応する画面なし | E-02 | ○ |
| C-08 | ParentIdFieldMapperを内部的に生成 | E-01 (間接・ファイル存在確認) | ○ |
| C-09 | MetaJoinFieldMapperを内部的に生成 | E-01 (間接・ファイル存在確認) | ○ |
| C-10 | Lucene BlockJoin機能を使用 | E-01 (間接推定) | ○ |
| C-11 | 同一シャード配置が必要 | E-01 (間接推定) | ○ |
| C-12 | joinフィールドは1インデックスに1つのみ | E-01 (間接推定) | ○ |
| C-13 | 多階層の親子関係を定義可能 | **根拠なし** | △ |
| C-14 | パフォーマンスへの影響の記述 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 多階層対応の詳細仕様はParentJoinFieldMapper.javaの実装確認が必要
  - 候補：ParentJoinFieldMapper.java
- ルーティング制約の詳細はドキュメント登録処理の確認が必要

## 5) リスクフラグ（レビュー観点）
- 0: プラグイン登録構造は明確
- 1: 親子関係の制約（同一シャード、単一joinフィールド）の詳細確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ParentJoinFieldMapperの多階層対応を確認
- [ ] ルーティング制約の正確性を確認
