---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：119-リフレッシュ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/refresh/TransportRefreshAction.java`
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.79）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.119）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransportBroadcastReplicationActionを拡張 | E-01 (54-58行目) | ○ |
| C-02 | BasicReplicationRequestを使用 | E-01 (85-88行目) | ○ |
| C-03 | waitForActiveShards = NONE | E-01 (87行目) | ○ |
| C-04 | RefreshResponseを結果集約して生成 | E-01 (92-99行目) | ○ |
| C-05 | TransportShardRefreshActionをコンストラクタ引数で受け取る | E-01 (66行目) | ○ |
| C-06 | RefreshAction.NAMEがアクション名 | E-01 (69行目) | ○ |
| C-07 | RefreshRequest::newでリクエスト生成 | E-01 (70行目) | ○ |
| C-08 | ReplicationResponseをnewShardResponseで生成 | E-01 (80-82行目) | ○ |
| C-09 | 画面No.79がリフレッシュに対応 | E-02 | ○ |
| C-10 | 機能No.119がリフレッシュ | E-03 | ○ |
| C-11 | FlushRequestと異なりシンプルなBroadcastRequest | E-01 (全体構造比較) | ○ |
| C-12 | プライマリ・レプリカ両方にリフレッシュ伝播 | E-01 (TransportBroadcastReplicationAction構造) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張に明確な根拠あり。低リスク。

## 6) レビュアーチェックリスト（最小）
- [ ] TransportShardRefreshActionの内部処理を確認
- [ ] RefreshRequestのパラメータ詳細を確認
