---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：120-リカバリ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。特に優先レビュー項目なし。

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/recovery/TransportRecoveryAction.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/recovery/RecoveryRequest.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（画面No.84）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`（機能No.120）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransportBroadcastByNodeActionを拡張 | E-01 (66行目) | ○ |
| C-02 | MANAGEMENTスレッドプールで実行 | E-01 (85行目) | ○ |
| C-03 | shardOperationでIndexShard.recoveryState()取得 | E-01 (131-134行目) | ○ |
| C-04 | allShardsIncludingRelocationTargetsで全シャード取得 | E-01 (138-139行目) | ○ |
| C-05 | METADATA_READブロックチェック | E-01 (143-144, 148-149行目) | ○ |
| C-06 | activeOnlyでstage != DONEフィルタ | E-01 (114-116行目) | ○ |
| C-07 | インデックス名でRecoveryStateをグループ化 | E-01 (106-121行目) | ○ |
| C-08 | RecoveryStateがnullの場合スキップ | E-01 (107-109行目) | ○ |
| C-09 | detailedのデフォルトはfalse | E-02 (52行目) | ○ |
| C-10 | activeOnlyのデフォルトはfalse | E-02 (53行目) | ○ |
| C-11 | STRICT_EXPAND_OPEN_CLOSEDをIndicesOptionsに使用 | E-02 (74行目) | ○ |
| C-12 | BroadcastRequestを拡張 | E-02 (50行目) | ○ |
| C-13 | @PublicApi(since = "1.0.0") | E-02 (49行目) | ○ |
| C-14 | 画面No.84がリカバリ情報に対応 | E-03 | ○ |
| C-15 | 機能No.120がリカバリ | E-04 | ○ |
| C-16 | RecoveryStateをシャード結果型として使用 | E-01 (66, 91行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張に明確な根拠あり。低リスク。

## 6) レビュアーチェックリスト（最小）
- [ ] RecoveryState.javaのStage、Type列挙値が正しいか確認
- [ ] RESTハンドラー（RestRecoveryAction）の実装を確認
- [ ] detailed=true時の追加情報内容を確認
