---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：122-キャッシュクリア

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **全キャッシュクリアのデフォルト動作**：パラメータ未指定時の動作はREST Handler側の実装に依存

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/TransportClearIndicesCacheAction.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/cache/clear/ClearIndicesCacheRequest.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransportBroadcastByNodeActionを継承 | E-01 66行目 | ○ |
| C-02 | MANAGEMENTスレッドプールで実行（falseフラグ） | E-01 92-93行目 | ○ |
| C-03 | METADATA_READレベルのブロックチェック | E-01 161行目, 166行目 | ○ |
| C-04 | ファイルキャッシュクリアでNode.fileCache().prune()使用 | E-01 124-130行目 | ○ |
| C-05 | IndicesService.clearIndexShardCache()でキャッシュクリア | E-01 132-138行目 | ○ |
| C-06 | nodeOperation()でforceClearNodewideCaches()実行 | E-01 143-149行目 | ○ |
| C-07 | queryCache, fieldDataCache, requestCache, fileCacheフラグを保持 | E-02 52-56行目 | ○ |
| C-08 | fileCacheフラグはV2.8.0以降でサポート | E-02 64-66行目 | ○ |
| C-09 | fieldsパラメータでフィールド指定可能 | E-02 56行目, 109-116行目 | ○ |
| C-10 | 全シャード対象 | E-01 155-157行目 | ○ |
| C-11 | 画面No.83がキャッシュクリアの主機能 | E-03 | ○ |
| C-12 | 強制クリア失敗時は警告ログを出力 | E-01 147行目 | ○ |
| C-13 | ShardPath.loadFileCachePath()でパス取得 | E-01 126行目 | ○ |
| C-14 | パラメータ未指定時は全キャッシュクリア | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パラメータ未指定時の動作はREST Handler（RestClearIndicesCacheAction）での実装に依存。ClearIndicesCacheRequestのデフォルト値はすべてfalseであるため、実際の挙動はREST Handler側で確認が必要。
  - 候補：`server/src/main/java/org/opensearch/rest/action/admin/indices/RestClearIndicesCacheAction.java`

## 5) リスクフラグ（レビュー観点）
- 1: パラメータ未指定時のデフォルト動作について要確認（中リスク）

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータ未指定時の実際のキャッシュクリア動作をRestClearIndicesCacheAction.javaで確認
- [ ] V2.8.0未満のクラスタでのfileCacheフラグの互換性動作を確認
