---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：123-オートフォースマージ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/index/autoforcemerge/AutoForceMergeManager.java`
- E-02: `server/src/main/java/org/opensearch/index/autoforcemerge/ForceMergeManagerSettings.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | デフォルトでは無効（cluster.auto_force_merge.enabled=false） | E-02 40-45行目 | ○ |
| C-02 | セグメント数閾値のデフォルトは1 | E-02 50-56行目 | ○ |
| C-03 | シャード間待機時間のデフォルトは15s | E-02 61-68行目 | ○ |
| C-04 | スケジューラ間隔のデフォルトは30分 | E-02 73-80行目 | ○ |
| C-05 | トランスログ経過時間閾値のデフォルトは30分 | E-02 85-92行目 | ○ |
| C-06 | CPU閾値のデフォルトは75% | E-02 97-104行目 | ○ |
| C-07 | ディスク閾値のデフォルトは85% | E-02 109-116行目 | ○ |
| C-08 | JVM閾値のデフォルトは75% | E-02 121-128行目 | ○ |
| C-09 | 同時実行倍率のデフォルトは2 | E-02 133-140行目 | ○ |
| C-10 | リモートストアが有効である必要がある | E-01 327-329行目 | ○ |
| C-11 | データノード（非ウォームノード）でのみ実行 | E-01 293行目 | ○ |
| C-12 | ウォームノードの存在が必要 | E-01 334-338行目 | ○ |
| C-13 | プライマリシャードのみが対象 | E-01 249行目 | ○ |
| C-14 | システムインデックス（"."始まり）は除外 | E-01 248行目 | ○ |
| C-15 | FORCE_MERGEスレッドプールで非同期実行 | E-01 228行目 | ○ |
| C-16 | 最大同時マージ数 = max(1, allocatedProcessors/8) * concurrencyMultiplier | E-01 425-427行目 | ○ |
| C-17 | トランスログ経過時間でソート（昇順） | E-01 253行目, 266-270行目 | ○ |
| C-18 | AbstractLifecycleComponentを継承 | E-01 58行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 全主張がソースコードから直接確認できており、低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] ResourceTrackerProviderの実装詳細を確認（リソース監視の精度）
- [ ] AutoForceMergeMetricsのテレメトリ出力先を確認
