---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：125-インデックススケーリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/admin/indices/scale/searchonly/TransportScaleIndexAction.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/scale/searchonly/ScaleIndexRequest.java`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | scaleDown=trueで検索専用モードへ縮小 | E-02 43-44行目 | ○ |
| C-02 | METADATA_WRITEレベルのブロックチェック | E-01 321-327行目 | ○ |
| C-03 | スケールダウン時に一時書き込みブロック追加 | E-01 184-191行目 | ○ |
| C-04 | プライマリシャードへのsyncリクエスト送信 | E-01 196-206行目 | ○ |
| C-05 | shard.sync() -> shard.flush() -> shard.waitForRemoteStoreSync() | E-01 286-288行目 | ○ |
| C-06 | FinalizeScaleDownTaskで検索専用モード確定 | E-01 223-225行目 | ○ |
| C-07 | スケールアップでルーティングテーブル再構築 | E-01 447行目 | ○ |
| C-08 | INDEX_SEARCH_ONLY_BLOCK_IDの解除 | E-01 453行目 | ○ |
| C-09 | AllocationService.reroute()でシャード再配置 | E-01 463-466行目 | ○ |
| C-10 | URGENTプライオリティのクラスタ状態更新 | E-01 349行目 | ○ |
| C-11 | 30秒のタイムアウトでオペレーション許可取得 | E-01 301行目 | ○ |
| C-12 | MANAGEMENTスレッドプールで実行 | E-01 141行目 | ○ |
| C-13 | インデックス名のバリデーション | E-02 72-78行目 | ○ |
| C-14 | ScaleIndexOperationValidatorによる前提条件チェック | E-01 313行目 | ○ |
| C-15 | ScaleIndexShardSyncManagerでノード間同期管理 | E-01 124行目, 201行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。全主張がソースコードから直接確認済み。

## 6) レビュアーチェックリスト（最小）
- [ ] ScaleIndexClusterStateBuilderの実装詳細を確認
- [ ] ScaleIndexOperationValidatorのバリデーション条件を確認
