---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：126-自動タグ付け共通基盤

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **IndexStoredRulePersistenceServiceの永続化詳細**：テスト用ファイルは確認したがメインソースを直接読み込んでいない

## 2) 参照した情報（Evidence一覧）
- E-01: `modules/autotagging-commons/common/src/main/java/org/opensearch/rule/autotagging/AutoTaggingRegistry.java`
- E-02: `modules/autotagging-commons/common/src/main/java/org/opensearch/rule/autotagging/Rule.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FeatureType名は最大30文字 | E-01 32行目 | ○ |
| C-02 | 同名FeatureTypeの重複登録は例外 | E-01 46-47行目 | ○ |
| C-03 | featureTypesRegistryMapはHashMap | E-01 28行目 | ○ |
| C-04 | FeatureTypeのnull/空チェック | E-01 52-62行目 | ○ |
| C-05 | getFeatureType()で未登録時はResourceNotFoundException | E-01 82-84行目 | ○ |
| C-06 | Ruleはid, description, attributeMap, featureType, featureValue, updatedAtを保持 | E-02 42-48行目 | ○ |
| C-07 | RuleValidatorによるバリデーション実行 | E-02 85-86行目 | ○ |
| C-08 | fromXContent()でJSONパース | E-02 122-124行目 | ○ |
| C-09 | toXContent()でJSON出力 | E-02 175-186行目 | ○ |
| C-10 | Writeable, ToXContentObjectを実装 | E-02 41行目 | ○ |
| C-11 | experimental注記 | E-01 22行目, E-02 39行目 | ○ |
| C-12 | IndexStoredRulePersistenceServiceでシステムインデックスに永続化 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- IndexStoredRulePersistenceServiceのメインソースを直接読み込んでいないため、永続化の詳細仕様は未確認
  - 候補：`modules/autotagging-commons/common/src/main/java/org/opensearch/rule/service/IndexStoredRulePersistenceService.java`

## 5) リスクフラグ（レビュー観点）
- 1: 永続化層の詳細仕様について中リスク

## 6) レビュアーチェックリスト（最小）
- [ ] IndexStoredRulePersistenceServiceの実装を確認
- [ ] AttributeValueStoreのインメモリ実装とスレッド安全性を確認
- [ ] ワークロード管理プラグインとの連携インターフェースを確認
