---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：128-スレッドプール管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし。

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/threadpool/ThreadPool.java`
- E-02: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ReportingServiceとSchedulerを実装 | E-01 90行目 | ○ |
| C-02 | Names内部クラスで30以上のプール名を定義 | E-01 99-130行目 | ○ |
| C-03 | ThreadPoolTypeにDIRECT/FIXED/RESIZABLE/SCALING/FORK_JOIN | E-01 141-146行目 | ○ |
| C-04 | THREAD_POOL_TYPESマップで種別対応を定義 | E-01 179-211行目 | ○ |
| C-05 | GENERICプールはmin(max(4*proc,128),512)スレッド | E-01 260-262行目 | ○ |
| C-06 | WRITEプールはallocatedProcessorsスレッド | E-01 264行目 | ○ |
| C-07 | SEARCHプールはリサイズ可能 | E-01 268-270行目, 188行目 | ○ |
| C-08 | FORCE_MERGEプールはallocatedProcessors/8 | E-01 300-302行目 | ○ |
| C-09 | MANAGEMENTプールは1-5スレッドスケーリング | E-01 283行目 | ○ |
| C-10 | ESTIMATED_TIME_INTERVAL_SETTINGデフォルト200ms | E-01 231-236行目 | ○ |
| C-11 | CLUSTER_THREAD_POOL_SIZE_SETTING動的設定 | E-01 238-242行目 | ○ |
| C-12 | PublicApi since 1.0.0 | E-01 89行目 | ○ |
| C-13 | SAMEプールはDIRECT型 | E-01 181行目 | ○ |
| C-14 | FLUSHプールはSCALING型 | E-01 191行目 | ○ |
| C-15 | 画面No.165がCat スレッドプールの主機能 | E-02 | ○ |
| C-16 | 画面No.110のホットスレッドの補助機能 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。全主張がソースコードから直接確認済み。

## 6) レビュアーチェックリスト（最小）
- [ ] CachedTimeThreadの実装詳細を確認
- [ ] 動的スレッドプールサイズ変更の適用タイミングを確認
