---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：129-ゲートウェイ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし。

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/gateway/GatewayService.java`
- E-02: `server/src/main/java/org/opensearch/gateway/Gateway.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AbstractLifecycleComponent + ClusterStateListenerを実装 | E-01 68行目 | ○ |
| C-02 | EXPECTED_DATA_NODES_SETTINGデフォルト-1 | E-01 71-76行目 | ○ |
| C-03 | RECOVER_AFTER_TIME_SETTINGデフォルト0ms | E-01 77-81行目 | ○ |
| C-04 | RECOVER_AFTER_DATA_NODES_SETTINGデフォルト-1 | E-01 82-87行目 | ○ |
| C-05 | STATE_NOT_RECOVERED_BLOCK（ブロックID=1、全レベルブロック） | E-01 89-97行目 | ○ |
| C-06 | デフォルト待機時間5分（expected_data_nodes設定時） | E-01 99行目 | ○ |
| C-07 | クラスタマネージャノードでのみリスナー登録 | E-01 150行目 | ○ |
| C-08 | ローカルノードがCM選出でない場合は処理しない | E-01 172行目 | ○ |
| C-09 | STATE_NOT_RECOVERED_BLOCKが無ければ既に復元済み | E-01 176行目 | ○ |
| C-10 | Coordinator使用時はRecoverStateUpdateTask | E-01 141行目 | ○ |
| C-11 | 非Coordinator時はGateway.performStateRecovery() | E-01 143-144行目 | ○ |
| C-12 | RecoverStateUpdateTaskでルーティングテーブル更新とブロック解除 | E-01 263-268行目 | ○ |
| C-13 | Gateway.performStateRecovery()で最新メタデータバージョンを選出 | E-02 86-101行目 | ○ |
| C-14 | requiredAllocation = 1（最低1ノードのメタデータ必要） | E-02 77行目 | ○ |
| C-15 | GENERICスレッドプールで実行 | E-01 228行目, 232行目 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。全主張がソースコードから直接確認済み。

## 6) レビュアーチェックリスト（最小）
- [ ] PersistedClusterStateServiceの永続化形式の詳細を確認
- [ ] リモートストア有効時のゲートウェイ処理との分岐を確認
- [ ] DanglingIndicesStateの検出・管理ロジックを確認
