---
generated_at: 2026-02-03 11:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：17-マッピング管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **MetadataMappingServiceの内部ロジック**：マッピング適用の詳細フロー未確認
  2. **フィールド型不変性の具体的制約**：型変更不可の具体的エラー処理未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/mapping/put/TransportPutMappingAction.java` - マッピング更新処理
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/mapping/get/` - マッピング取得関連ファイル群
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransportPutMappingActionはTransportClusterManagerNodeActionを継承 | E-01 (73行目) | ○ |
| C-02 | TransportIndicesResolvingActionを実装 | E-01 (75行目) | ○ |
| C-03 | MetadataMappingService, RequestValidators, MappingTransformerRegistryに依存 | E-01 (79-81行目) | ○ |
| C-04 | RequestValidators<PutMappingRequest>で追加バリデーション | E-01 (80行目) | ○ |
| C-05 | MappingTransformerRegistryでマッピング変換 | E-01 (81行目) | ○ |
| C-06 | Get Mapping, Get Field Mapping, Put Mappingの3つのAPI | E-02 | ○ |
| C-07 | 画面No.50,51,52が関連画面 | E-03 | ○ |
| C-08 | AutoPutMappingActionが自動マッピング更新を担当 | E-02 (ファイル存在確認) | ○ |
| C-09 | GetFieldMappingsIndexRequestでインデックス単位の処理 | E-02 (ファイル存在確認) | ○ |
| C-10 | PutMappingClusterStateUpdateRequestでクラスタ状態更新 | E-01 (関連ファイル) | ○ |
| C-11 | マッピング取得はクラスタ状態からの参照のため高速 | E-02 (一般的な特性) | ○ |
| C-12 | マッピング更新はクラスタ状態の変更として伝播 | E-01 (TransportClusterManagerNodeAction) | ○ |
| C-13 | MetadataMappingServiceの内部ロジック詳細 | **根拠なし** | △ |
| C-14 | 既存フィールドの型変更時の具体的エラー処理 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: MetadataMappingService.javaの全コードを精読しておらず、マッピング適用の詳細フローは推定。
  - 候補：`server/src/main/java/org/opensearch/cluster/metadata/MetadataMappingService.java`
- C-14: 既存フィールドの型変更時に返却されるエラーの具体的な内容は未確認。
  - 候補：MapperService.java, MapperMergeValidator

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API構造と依存関係はコードで確認済み
- 1: 中リスク - MetadataMappingServiceの内部ロジック
- 1: 中リスク - マッピング変換の詳細動作

## 6) レビュアーチェックリスト（最小）
- [ ] MetadataMappingServiceのマッピング適用ロジックを確認
- [ ] MappingTransformerRegistryの変換処理を確認
- [ ] 既存フィールドの型変更試行時のエラー内容を確認
