---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：21-マルチサーチ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **REST APIエンドポイント詳細**：RestMultiSearchActionのコード未精査
  2. **セキュリティ権限制御の詳細**：Security Pluginのコード未参照

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/search/MultiSearchAction.java` - アクション名定義
- E-02: `server/src/main/java/org/opensearch/action/search/TransportMultiSearchAction.java` - 実行ロジック
- E-03: `server/src/main/java/org/opensearch/action/search/MultiSearchRequest.java` - リクエスト構造・バリデーション
- E-04: `server/src/main/java/org/opensearch/action/search/MultiSearchResponse.java` - レスポンス構造
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名はindices:data/read/msearch | E-01 (45行目) | ○ |
| C-02 | NDJSON形式で入力を受け取る | E-03 (readMultiLineFormat, 193-320行目) | ○ |
| C-03 | リクエストリスト空はバリデーションエラー | E-03 (validate, 131-147行目) | ○ |
| C-04 | maxConcurrentSearchRequestsは1以上 | E-03 (118-119行目) | ○ |
| C-05 | デフォルト並行数 = max(1, numDataNodes * min(searchThreadPoolSize, 10)) | E-02 (140-145行目) | ○ |
| C-06 | クラスタブロック（READ）チェック | E-02 (112行目) | ○ |
| C-07 | ConcurrentLinkedQueueでリクエストを管理 | E-02 (119行目) | ○ |
| C-08 | AtomicArrayで結果を管理 | E-02 (127行目) | ○ |
| C-09 | 親タスクキャンセル時にドレイン処理 | E-02 (199-211行目) | ○ |
| C-10 | 同一スレッド検出時にgenericスレッドプールにフォーク | E-02 (213-216行目) | ○ |
| C-11 | CancellableTaskとして実装 | E-03 (createTask, 392-404行目) | ○ |
| C-12 | shouldCancelChildrenOnCancellation = true | E-03 (400-401行目) | ○ |
| C-13 | レスポンス順序は入力順序を維持 | E-02 (SearchRequestSlot.responseSlot, 252-261行目) | ○ |
| C-14 | took時間はナノ秒からミリ秒に変換 | E-02 (233-234行目) | ○ |
| C-15 | 個別検索失敗はItemのexceptionフィールドに格納 | E-04 (86-142行目) | ○ |
| C-16 | cancel_after_time_intervalパラメータサポート | E-03 (279-281行目) | ○ |
| C-17 | REST APIエンドポイントは POST /_msearch, POST /{index}/_msearch | **根拠なし** | △ |
| C-18 | インデックスレベルの権限チェックが行われる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- REST APIエンドポイントの詳細：RestMultiSearchActionの内容を精査していないため、エンドポイントパスの正確性を確認できない
  - 候補：RestMultiSearchAction.java / OpenSearch REST APIドキュメント
- セキュリティ権限制御：Security Pluginのコードを参照していないため、権限チェックの詳細が不明
  - 候補：Security Plugin ソースコード / OpenSearch Security ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: REST APIパスの正確性（一般的なOpenSearch API仕様と一致する可能性が高い）
- 0: セキュリティ権限制御（標準的なアクション名ベースの制御）

## 6) レビュアーチェックリスト（最小）
- [ ] REST APIエンドポイント（/_msearch）の正確性を確認
- [ ] デフォルト並行数の算出ロジックが最新のコードと一致するか確認
- [ ] キャンセル伝播の挙動がドキュメント記載通りか確認
