---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：22-スクロール検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **スナップショット一貫性の詳細動作**：Lucene Searcherのスナップショット保持メカニズム未精査
  2. **keep_alive更新メカニズムの詳細**：シャードレベルのコンテキスト管理コード未参照

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/search/SearchScrollAction.java` - アクション名定義
- E-02: `server/src/main/java/org/opensearch/action/search/TransportSearchScrollAction.java` - 実行ロジック
- E-03: `server/src/main/java/org/opensearch/action/search/SearchScrollRequest.java` - リクエスト構造
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名はindices:data/read/scroll | E-01 (45行目) | ○ |
| C-02 | scroll_idは必須パラメータ | E-03 (validate, 85-91行目) | ○ |
| C-03 | QUERY_THEN_FETCH_TYPEとQUERY_AND_FETCH_TYPEの2タイプ | E-02 (84-108行目) | ○ |
| C-04 | 不明なタイプはIllegalArgumentException | E-02 (110行目) | ○ |
| C-05 | WorkloadGroupTask対応 | E-02 (78-79行目) | ○ |
| C-06 | SearchTaskとして登録 | E-03 (139-141行目) | ○ |
| C-07 | scrollパラメータはTimeValue形式 | E-03 (127-129行目) | ○ |
| C-08 | TransportSearchHelper.parseScrollIdでscroll_id解析 | E-02 (82行目) | ○ |
| C-09 | SearchPhaseControllerで結果マージ | E-02 (55-56行目, inject) | ○ |
| C-10 | SearchTransportServiceでシャード通信 | E-02 (54行目, inject) | ○ |
| C-11 | fromXContentでJSON/リクエストボディパース対応 | E-03 (185-205行目) | ○ |
| C-12 | QUERY_AND_FETCH廃止予定 | E-02 (97行目 TODO) | ○ |
| C-13 | スナップショット一貫性で検索中の変更が反映されない | **根拠なし** | △ |
| C-14 | keep_aliveの自動更新メカニズム | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- スナップショット一貫性：SearchContext/ReaderContextのスナップショット保持メカニズムの詳細コードを参照していない
  - 候補：SearchService.java / ReaderContext.java
- keep_alive更新：シャードレベルでのコンテキスト有効期限更新ロジックの詳細
  - 候補：SearchService.java / ReaderContext.java

## 5) リスクフラグ（レビュー観点）
- 0: スナップショット一貫性（OpenSearch/Luceneの標準的な挙動と一致）
- 1: keep_alive更新の正確な動作タイミング

## 6) レビュアーチェックリスト（最小）
- [ ] スクロールコンテキストのメモリ影響に関する記載が十分か確認
- [ ] QUERY_AND_FETCH_TYPEの廃止状況を確認
- [ ] keep_alive更新タイミングの正確性を確認
