---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 10
  claims_with_evidence: 9
  claims_without_evidence: 1
confidence_derived: 0.90
---

# 根拠レポート：24-ストリーミング検索

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：9 / 10、根拠なし：1
- 優先レビュー（高）
  1. **ストリーミングレスポンスの具体的な返却メカニズム**：StreamSearchActionListener等の詳細未精査

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/search/StreamSearchAction.java` - アクション名定義
- E-02: `server/src/main/java/org/opensearch/action/search/StreamTransportSearchAction.java` - ストリーミング検索ロジック
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名はindices:data/read/search/stream | E-01 (21行目) | ○ |
| C-02 | TransportSearchActionを継承 | E-02 (43行目) | ○ |
| C-03 | QUERY_THEN_FETCHのみサポート | E-02 (114-138行目) | ○ |
| C-04 | preFilter非サポート | E-02 (102-103行目) | ○ |
| C-05 | StreamSearchQueryThenFetchAsyncActionを生成 | E-02 (116-135行目) | ○ |
| C-06 | StreamQueryPhaseResultConsumerで結果集約 | E-02 (105-112行目) | ○ |
| C-07 | @opensearch.internal | E-02 (42行目) | ○ |
| C-08 | StreamTransportServiceが@Nullable | E-02 (49行目) | ○ |
| C-09 | CircuitBreakerService使用 | E-02 (107行目) | ○ |
| C-10 | ストリーミング形式での段階的結果返却 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ストリーミング返却メカニズムの詳細：StreamSearchActionListener, StreamTransportServiceの具体的な動作
  - 候補：StreamSearchActionListener.java / StreamTransportService.java

## 5) リスクフラグ（レビュー観点）
- 1: ストリーミング返却の具体的なメカニズムの正確性

## 6) レビュアーチェックリスト（最小）
- [ ] ストリーミング形式の結果返却メカニズムを確認
- [ ] StreamTransportServiceがnullの場合の動作を確認
- [ ] REST APIエンドポイントの有無を確認（ストリーミング専用のREST APIがあるか）
