---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：26-フィールドキャパビリティ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **REST APIエンドポイントパス**：RESTハンドラーの詳細コード未参照

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/action/fieldcaps/TransportFieldCapabilitiesAction.java` - メイン実行ロジック
- E-02: `server/src/main/java/org/opensearch/action/fieldcaps/` - ディレクトリ構造
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ローカルとリモートのインデックス解決 | E-01 (97-100行目) | ○ |
| C-02 | CountDownで並行完了待ち | E-01 (102行目) | ○ |
| C-03 | canMatch最適化（indexFilter） | E-01 (119-121行目) | ○ |
| C-04 | merge_results=falseでリモートに送信 | E-01 (145行目) | ○ |
| C-05 | クラスタエイリアスプレフィクス付与 | E-01 (153-157行目) | ○ |
| C-06 | merge()で型情報統合 | E-01 (190-211行目) | ○ |
| C-07 | addUnmappedFields()でunmapped追加 | E-01 (213-224行目) | ○ |
| C-08 | innerMerge()でBuilder統合 | E-01 (226-240行目) | ○ |
| C-09 | TransportIndicesResolvingAction実装 | E-01 (68-69行目) | ○ |
| C-10 | 個別インデックスの失敗は無視 | E-01 (127-129行目) | ○ |
| C-11 | FieldCapabilities.Builder.add()で統合 | E-01 (239行目) | ○ |
| C-12 | multiTypes判定 | E-01 (202行目) | ○ |
| C-13 | totalNumRequest=0の場合は空レスポンス | E-01 (113-114行目) | ○ |
| C-14 | REST APIエンドポイントパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- REST APIエンドポイント：RESTハンドラーの詳細コードを参照していない
  - 候補：RestFieldCapabilitiesAction.java（存在する場合）

## 5) リスクフラグ（レビュー観点）
- 0: REST APIパスの正確性（標準的なOpenSearch API仕様と一致する可能性が高い）

## 6) レビュアーチェックリスト（最小）
- [ ] REST APIエンドポイントパスの正確性を確認
- [ ] include_unmappedの正確な動作を確認
- [ ] リモートクラスタのエラーハンドリングを確認
