---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：29-検索プロファイリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **プロファイリング有効化のトリガーフロー**：SearchService側のプロファイリング開始ロジック未精査
  2. **ブレークダウン項目の詳細**：AbstractProfileBreakdownの具体的な内訳項目未確認

## 2) 参照した情報（Evidence一覧）
- E-01: `server/src/main/java/org/opensearch/search/profile/Profilers.java` - プロファイラー管理
- E-02: `server/src/main/java/org/opensearch/search/profile/ProfileShardResult.java` - シャード結果構造
- E-03: `server/src/main/java/org/opensearch/search/profile/` - ディレクトリ構造
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Profilers.javaはPublicApi(since = "1.0.0") | E-01 (58行目) | ○ |
| C-02 | QueryProfiler, AggregationProfiler, FetchProfilerの3種 | E-01 (62-64行目) | ○ |
| C-03 | コンカレント対応（ConcurrentAggregationProfiler） | E-01 (82行目) | ○ |
| C-04 | ConcurrentQueryProfileTree/ConcurrentQueryProfiler | E-01 (91行目) | ○ |
| C-05 | ContextIndexSearcherにプロファイラー設定 | E-01 (93行目) | ○ |
| C-06 | ProfileShardResultにquery/agg/fetch/network | E-02 (57-63行目) | ○ |
| C-07 | Version.V_3_2_0でFetchProfile追加 | E-02 (99-103行目) | ○ |
| C-08 | NetworkTimeの管理 | E-02 (63行目, 133-139行目) | ○ |
| C-09 | カスタムプラグインメトリクスサポート | E-01 (66行目, 74-78行目) | ○ |
| C-10 | AbstractInternalProfileTree存在 | E-03 | ○ |
| C-11 | Timer.java存在 | E-03 | ○ |
| C-12 | SearchServiceでのプロファイリング有効化フロー | **根拠なし** | △ |
| C-13 | ブレークダウン項目（create_weight, build_scorer等） | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- プロファイリング有効化フロー：SearchServiceでprofile=trueの場合にどのようにProfilersが作成されるか
  - 候補：SearchService.java / SearchContext.java
- ブレークダウン項目：AbstractProfileBreakdownの具体的な項目リスト
  - 候補：query/QueryTimingType.java等

## 5) リスクフラグ（レビュー観点）
- 1: プロファイリング有効化フローの正確性
- 0: ブレークダウン項目の一般的な記述

## 6) レビュアーチェックリスト（最小）
- [ ] SearchServiceでのプロファイリング有効化フローを確認
- [ ] ブレークダウン項目の完全なリストを確認
- [ ] コンカレントセグメント検索時のプロファイリング動作を確認
