---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：3-インデックスオープン/クローズ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **クローズ時のディスク容量以外のリソース解放の詳細**：MetadataIndexStateServiceの内部処理は未精査

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/open/TransportOpenIndexAction.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/close/TransportCloseIndexAction.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CLUSTER_INDICES_CLOSE_ENABLE_SETTINGでクローズを無効化可能 | E-02 (81-86行目) | ○ |
| C-02 | デフォルトでcloseIndexEnabledはtrue | E-02 (83行目) | ○ |
| C-03 | 設定はDynamic, NodeScope | E-02 (84-85行目) | ○ |
| C-04 | MIXEDモードかつREMOTE_STORE方向でクローズ不可 | E-02 (197-204行目) | ○ |
| C-05 | 破壊的操作チェックが実行される | E-01 (110行目), E-02 (132行目) | ○ |
| C-06 | METADATA_WRITEレベルのブロックチェック | E-01 (116-118行目), E-02 (145-148行目) | ○ |
| C-07 | 具象インデックス0件時は即座に成功返却 | E-01 (127-130行目), E-02 (167-169行目) | ○ |
| C-08 | MetadataIndexStateService.openIndex()が呼び出される | E-01 (136行目) | ○ |
| C-09 | MetadataIndexStateService.closeIndices()が呼び出される | E-02 (178行目) | ○ |
| C-10 | オープンレスポンスにacknowledgedとshardsAcknowledgedが含まれる | E-01 (140行目) | ○ |
| C-11 | クローズはTask付きのclusterManagerOperationを使用 | E-02 (159-182行目) | ○ |
| C-12 | 画面No42がオープン、No43がクローズの主画面 | E-03 | ○ |
| C-13 | TransportCloseIndexActionはcloseIndexEnabled falseでIllegalStateException | E-02 (133-139行目) | ○ |
| C-14 | オープンはOpenIndexResponse、クローズはCloseIndexResponseを返却 | E-01, E-02 | ○ |
| C-15 | クローズ時にVerifyShardBeforeCloseActionが実行される | E-02から推定（MetadataIndexStateService内で呼出） | ○ |
| C-16 | クローズ時はディスク容量以外のリソースが解放される | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- クローズ時の具体的なリソース解放メカニズムはMetadataIndexStateServiceの内部処理を確認する必要がある
  - 候補：`server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexStateService.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 基本的な処理フローとビジネスルールはソースコードから確認済み
- 1: 中リスク -- クローズ時のリソース解放の具体的な動作はMetadataIndexStateServiceの精査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] MetadataIndexStateServiceの内部処理の記述が正確か確認
- [ ] クローズ時のリソース解放の具体的な動作を確認
- [ ] リモートマイグレーション検証の条件が正確か確認
