---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：32-メトリクス集計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **precision_thresholdの範囲上限40000**：公式ドキュメント確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/search/aggregations/metrics/AvgAggregationBuilder.java` - Avg集計ビルダー
- E-02: `server/src/main/java/org/opensearch/search/aggregations/metrics/AvgAggregator.java` - Avg集計実行クラス
- E-03: `server/src/main/java/org/opensearch/search/aggregations/metrics/CompensatedSum.java` - 補償和アルゴリズム
- E-04: `server/src/main/java/org/opensearch/search/aggregations/metrics/HyperLogLogPlusPlus.java` - HLL++
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面機能マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AvgAggregationBuilder.NAME = "avg" | E-01 | ○ |
| C-02 | LeafOnly制約（サブ集計不可） | E-01 | ○ |
| C-03 | AvgAggregatorはNumericMetricsAggregator.SingleValue継承 | E-02 | ○ |
| C-04 | StarTreePreComputeCollector実装 | E-02 | ○ |
| C-05 | counts, sums, compensationsの3配列管理 | E-02 | ○ |
| C-06 | CompensatedSumによるKahan補償和 | E-03 | ○ |
| C-07 | HyperLogLog++によるCardinality推定 | E-04 | ○ |
| C-08 | ValuesSource.Numericによるフィールドデータ取得 | E-01, E-02 | ○ |
| C-09 | 画面No.21で補助機能として利用 | E-06 | ○ |
| C-10 | カテゴリは「集計・分析」 | E-05 | ○ |
| C-11 | REGISTRY_KEYによるValuesSourceRegistryへの登録 | E-01 | ○ |
| C-12 | InternalAvgでsum/countを保持しreduce | E-02 | ○ |
| C-13 | SortedNumericDoubleValuesで数値読取 | E-02 | ○ |
| C-14 | DocValueFormatによるフォーマット | E-02 | ○ |
| C-15 | TDigestによるPercentiles近似計算 | E-04 | ○ |
| C-16 | BigArraysによるメモリ管理 | E-02 | ○ |
| C-17 | Star-Tree利用時の事前集計高速化 | E-02 | ○ |
| C-18 | precision_thresholdの範囲が0-40000 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- precision_thresholdの具体的な上限値はCardinalityAggregationBuilderのバリデーションロジックで確認が必要
  - 候補：CardinalityAggregationBuilder.java

## 5) リスクフラグ（レビュー観点）
- 0: メトリクス集計の基本構造は十分にコードで確認済み
- 0: Avg集計の実装詳細はコードから直接確認済み
- 1: precision_thresholdの範囲上限は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] precision_thresholdのバリデーション範囲をCardinalityAggregationBuilder.javaで確認
- [ ] TDigest圧縮パラメータのデフォルト値をコードで確認
- [ ] Extended Stats集計のsigmaパラメータのデフォルト値を確認
