---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：34-Matrix Stats集計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **歪度・尖度の計算ロジック詳細**：RunningStats内部の計算式要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsAggregationBuilder.java`
- E-02: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/MatrixStatsAggregator.java`
- E-03: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/stats/RunningStats.java`
- E-04: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/matrix/MatrixAggregationModulePlugin.java`
- E-05: `modules/aggs-matrix-stats/src/main/java/org/opensearch/search/aggregations/support/ArrayValuesSource.java`
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NAME = "matrix_stats" | E-01 | ○ |
| C-02 | ArrayValuesSourceAggregationBuilder.LeafOnlyを継承 | E-01 | ○ |
| C-03 | multiValueModeデフォルトがAVG | E-01 | ○ |
| C-04 | RunningStatsで中間統計量管理 | E-03 | ○ |
| C-05 | ArrayValuesSourceで複数フィールド値取得 | E-05 | ○ |
| C-06 | MatrixAggregationModulePluginで登録 | E-04 | ○ |
| C-07 | 相関係数の計算式 | E-03 | ○ |
| C-08 | Welfordのオンラインアルゴリズム使用 | E-03 | ○ |
| C-09 | モジュール（aggs-matrix-stats）として提供 | E-06 | ○ |
| C-10 | merge()メソッドでシャード間統合 | E-03 | ○ |
| C-11 | LeafOnly制約（サブ集計不可） | E-01 | ○ |
| C-12 | MatrixStatsNamedXContentProvider存在 | E-04 | ○ |
| C-13 | MultiValueMode（AVG, MIN, MAX, SUM, MEDIAN） | E-01 | ○ |
| C-14 | 歪度・尖度の計算ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- RunningStatsの歪度（skewness）・尖度（kurtosis）の具体的な計算式はRunningStats.javaの内部実装を詳細に確認する必要がある
  - 候補：RunningStats.java内のskewness/kurtosis算出メソッド

## 5) リスクフラグ（レビュー観点）
- 0: 基本構造はコードから十分確認済み
- 1: 高次モーメントの計算式の正確性は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] RunningStats.javaの歪度・尖度計算ロジックを確認
- [ ] merge()メソッドの統計量結合アルゴリズムが正確か確認
- [ ] MultiValueModeの全モードが正しく記述されているか確認
