---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：35-Star-Tree インデックス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **Star-Tree構築時の具体的パフォーマンスオーバーヘッド**：根拠不足
  2. **max_leaf_docsのデフォルト値**：コード確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/search/startree/StarTreeQueryHelper.java`
- E-02: `server/src/main/java/org/opensearch/search/startree/StarTreeQueryContext.java`
- E-03: `server/src/main/java/org/opensearch/search/startree/filter/DimensionFilter.java`
- E-04: `server/src/main/java/org/opensearch/index/compositeindex/datacube/startree/fileformats/meta/StarTreeMetadata.java`
- E-05: `server/src/main/java/org/opensearch/index/compositeindex/datacube/Metric.java`
- E-06: `server/src/main/java/org/opensearch/index/compositeindex/datacube/DimensionType.java`
- E-07: `server/src/main/java/org/opensearch/index/compositeindex/CompositeIndexValidator.java`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | isStarTreeSupported()の判定条件 | E-01 | ○ |
| C-02 | aggregations存在、compositeIndex存在、postFilterなしの3条件 | E-01 | ○ |
| C-03 | getSupportedStarTree()でCompositeIndexFieldInfo取得 | E-01 | ○ |
| C-04 | getStarTreeValues()でLeafReaderContextから取得 | E-01 | ○ |
| C-05 | CompositeIndexReaderからStarTreeValues取得 | E-01 | ○ |
| C-06 | DimensionFilter（ExactMatch, RangeMatch, MatchAll, MatchNone） | E-03 | ○ |
| C-07 | StarTreeMetadataでメタ情報を保持 | E-04 | ○ |
| C-08 | Metric定義でfield + stats構成 | E-05 | ○ |
| C-09 | DimensionTypeの存在 | E-06 | ○ |
| C-10 | CompositeIndexValidatorで設定検証 | E-07 | ○ |
| C-11 | 実験的機能（@opensearch.experimental） | E-01 | ○ |
| C-12 | FixedLengthStarTreeNodeの固定長バイナリ形式 | E-04 | ○ |
| C-13 | Star-Tree構築のパフォーマンスオーバーヘッド | **根拠なし** | △ |
| C-14 | max_leaf_docsのデフォルト値 | **根拠なし** | △ |
| C-15 | O(log N)〜O(1)の計算量 | E-01 | ○ |
| C-16 | カテゴリは「集計・分析」 | E-08 | ○ |

## 4) 不足情報（Unknown / Missing）
- Star-Tree構築時の具体的なパフォーマンスオーバーヘッドはベンチマークデータからの確認が必要
  - 候補：パフォーマンステスト結果 / OpenSearch公式ドキュメント
- max_leaf_docsのデフォルト値はCompositeIndexConstantsまたはStar-Treeビルダー設定から確認が必要
  - 候補：CompositeIndexConstants.java / StarTreeBuilder.java

## 5) リスクフラグ（レビュー観点）
- 1: 実験的機能のため、APIやデータ形式が変更される可能性
- 0: 検索時のStar-Tree利用判定ロジックはコードから確認済み
- 1: パフォーマンス特性の記述は推定に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] CompositeIndexConstants.javaでmax_leaf_docsのデフォルト値を確認
- [ ] StarTreeBuilderのインデックス時構築フローを確認
- [ ] 実験的機能のステータスが最新であるか確認
