---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：37-インジェスト共通プロセッサ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **プロセッサ完全一覧の網羅性**：ファイル一覧との照合が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/IngestCommonModulePlugin.java`
- E-02: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/GrokProcessor.java`
- E-03: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/SetProcessor.java`
- E-04: `modules/ingest-common/src/main/java/org/opensearch/ingest/common/ConvertProcessor.java`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: ファイルシステム一覧（modules/ingest-common/src/main/java下の*.java）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IngestCommonModulePluginがPlugin, ActionPlugin, IngestPluginを実装 | E-01 | ○ |
| C-02 | PROCESSORS_ALLOWLIST_SETTING定義 | E-01 | ○ |
| C-03 | WATCHDOG_INTERVAL設定（デフォルト1秒） | E-01 | ○ |
| C-04 | WATCHDOG_MAX_EXECUTION_TIME設定 | E-01 | ○ |
| C-05 | Grokプロセッサの正規表現パターンマッチング | E-02 | ○ |
| C-06 | SetProcessor, RemoveProcessor, RenameProcessorの存在 | E-03, E-07 | ○ |
| C-07 | ConvertProcessorの型変換機能 | E-04 | ○ |
| C-08 | 約30種類のプロセッサ | E-07 | ○ |
| C-09 | 画面No.134で補助機能、No.135で主機能 | E-06 | ○ |
| C-10 | カテゴリは「データ取り込み」 | E-05 | ○ |
| C-11 | ForEachプロセッサの配列要素処理 | E-07 | ○ |
| C-12 | AbstractStringProcessorの文字列操作基底 | E-07 | ○ |
| C-13 | GrokProcessorGetActionのパターン一覧API | E-02 | ○ |
| C-14 | FingerprintProcessorのハッシュ計算 | E-07 | ○ |
| C-15 | 全プロセッサ一覧の完全な網羅性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- IngestCommonModulePlugin.getProcessors()の返却値から全プロセッサ名を網羅的に確認する必要がある
  - 候補：IngestCommonModulePlugin.javaのgetProcessors()メソッド内部

## 5) リスクフラグ（レビュー観点）
- 0: 主要プロセッサの存在と機能はファイル一覧から確認済み
- 1: プロセッサ完全一覧に漏れがある可能性

## 6) レビュアーチェックリスト（最小）
- [ ] IngestCommonModulePlugin.getProcessors()で返却される全プロセッサ名を確認
- [ ] WATCHDOG_MAX_EXECUTION_TIMEのデフォルト値を確認
- [ ] DropプロセッサとPipelineプロセッサがingest-commonではなくserver coreに含まれることを確認
