---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：42-Kafkaインジェスト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/ingestion-kafka/src/main/java/org/opensearch/plugin/kafka/KafkaPlugin.java`
- E-02: `plugins/ingestion-kafka/src/main/java/org/opensearch/plugin/kafka/KafkaSourceConfig.java`
- E-03: `plugins/ingestion-kafka/src/main/java/org/opensearch/plugin/kafka/KafkaPartitionConsumer.java`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KafkaPluginはIngestionConsumerPluginを実装しTYPE="KAFKA" | E-01 (20, 24行目) | ○ |
| C-02 | KafkaConsumerFactoryを提供 | E-01 (34行目) | ○ |
| C-03 | topic, bootstrap_serversが必須パラメータ | E-02 (21-22, 38-39行目) | ○ |
| C-04 | auto.offset.resetのデフォルトは"none" | E-02 (43行目) | ○ |
| C-05 | max.poll.recordsはmaxPollSizeのデフォルト値を使用 | E-02 (47行目) | ○ |
| C-06 | トピック存在チェック（IllegalArgumentException） | E-03 (82-83行目) | ○ |
| C-07 | パーティション存在チェック（IllegalArgumentException） | E-03 (84-86行目) | ○ |
| C-08 | ByteArrayDeserializerを使用 | E-03 (126-127行目) | ○ |
| C-09 | AccessController.doPrivilegedでKafkaConsumerを生成 | E-03 (123-129行目) | ○ |
| C-10 | readNextのmaxMessagesパラメータは無視 | E-03 (139行目 Javadoc) | ○ |
| C-11 | fetchメソッドでseek + pollを実行 | E-03 (226-251行目) | ○ |
| C-12 | ラグ計算: endOffset - lastFetchedOffset - 1 | E-03 (280行目) | ○ |
| C-13 | タイムスタンプでメッセージが見つからない場合auto.offset.resetにフォールバック | E-03 (205-216行目) | ○ |
| C-14 | timeoutMillisデフォルト1000ms | E-03 (49行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] KafkaConsumerFactoryの実装が設計書の記載と一致するか確認
- [ ] KafkaOffset, KafkaMessageのデータ構造が正しいか確認
