---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：46-検索パイプライン共通プロセッサ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし。全主張に根拠あり。

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/search-pipeline-common/src/main/java/org/opensearch/search/pipeline/common/SearchPipelineCommonModulePlugin.java`
- E-02: ディレクトリ構造（modules/search-pipeline-common/src/main/java/）
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SearchPipelinePluginを実装 | E-01 (29行目) | ○ |
| C-02 | 6種のリクエストプロセッサを登録 | E-01 (73-92行目) | ○ |
| C-03 | 5種のレスポンスプロセッサを登録 | E-01 (95-112行目) | ○ |
| C-04 | SearchPhaseResultsProcessorの共通実装は空 | E-01 (115-117行目) | ○ |
| C-05 | REQUEST_PROCESSORS_ALLOWLIST_SETTING定義 | E-01 (31-36行目) | ○ |
| C-06 | RESPONSE_PROCESSORS_ALLOWLIST_SETTING定義 | E-01 (38-43行目) | ○ |
| C-07 | SEARCH_PHASE_RESULTS_PROCESSORS_ALLOWLIST_SETTING定義 | E-01 (45-50行目) | ○ |
| C-08 | 許可リスト未設定時は全プロセッサが利用可能 | E-01 (124行目) | ○ |
| C-09 | 未知プロセッサ名でIllegalArgumentException | E-01 (132-136行目) | ○ |
| C-10 | FilterQueryRequestProcessorファクトリがnamedXContentRegistryを使用 | E-01 (79行目) | ○ |
| C-11 | ScriptRequestProcessorファクトリがscriptServiceを使用 | E-01 (81行目) | ○ |
| C-12 | Setting.Property.NodeScopeの設定 | E-01 (35行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各プロセッサの個別実装パラメータが設計書の記載と一致するか確認
- [ ] AclRoutingSearchProcessorのセキュリティ動作を確認
