---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 13
  claims_with_evidence: 11
  claims_without_evidence: 2
confidence_derived: 0.85
---

# 根拠レポート：47-クラスタヘルス

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：11 / 13、根拠なし：2
- 優先レビュー（高）
  1. **ClusterStateHealthの集計ロジック詳細**：ヘルス集計クラスの詳細実装は未確認
  2. **TransportClusterHealthActionの待機条件評価ロジック**：clusterManagerOperationメソッドの全体は先頭80行のみ確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthRequest.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/cluster/health/ClusterHealthResponse.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/cluster/health/TransportClusterHealthAction.java`（先頭80行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | green/yellow/redの3段階ステータス | E-01 (66行目 ClusterHealthStatus) | ○ |
| C-02 | デフォルトタイムアウト30秒 | E-01 (65行目) | ○ |
| C-03 | waitForStatus, waitForNoRelocatingShards等の待機パラメータ | E-01 (66-71行目) | ○ |
| C-04 | Level列挙型（CLUSTER/INDICES/SHARDS） | E-01 (77行目) | ○ |
| C-05 | ensureNodeWeighedInパラメータ | E-01 (72行目) | ○ |
| C-06 | TransportClusterManagerNodeReadActionを継承 | E-03 (41行目) | ○ |
| C-07 | ClusterHealthResponseはStatusToXContentObjectを実装 | E-02 (74行目) | ○ |
| C-08 | cluster_name, status, timed_out等のレスポンスフィールド | E-02 (75-80行目) | ○ |
| C-09 | 画面90がクラスタヘルスに対応 | E-04 | ○ |
| C-10 | 画面151がCat ヘルスに対応 | E-04 | ○ |
| C-11 | ClusterStateObserverで待機条件監視 | E-03 (43行目 import) | ○ |
| C-12 | ClusterStateHealthのヘルス集計ロジック詳細 | **根拠なし** | △ |
| C-13 | TransportClusterHealthActionのclusterManagerOperation全体の処理フロー | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ClusterStateHealthの詳細実装は未確認
  - 候補：`server/src/main/java/org/opensearch/cluster/health/ClusterStateHealth.java`
- TransportClusterHealthActionのclusterManagerOperationメソッド全体は先頭80行のみ確認
  - 候補：`TransportClusterHealthAction.java`の全文読み込み

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ヘルス集計ロジックと待機条件評価の詳細は推定に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] ClusterStateHealthのステータス判定ロジックが設計書の記載と一致するか確認
- [ ] TransportClusterHealthActionの待機条件評価の全体フローを確認
- [ ] NodeDecommissionedException, NodeWeighedAwayExceptionの発生条件を確認
