---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：49-ノード情報・統計

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **NodeServiceのinfo()/stats()メソッドの詳細実装**：NodeServiceの実装は未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/cluster/node/info/TransportNodesInfoAction.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/cluster/node/stats/TransportNodesStatsAction.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TransportNodesInfoActionはTransportNodesActionを継承 | E-01 (56行目) | ○ |
| C-02 | 12種のメトリクスカテゴリ（NodesInfo） | E-01 (110-122行目) | ○ |
| C-03 | NodeService.info()を呼び出し | E-01 (109行目) | ○ |
| C-04 | MANAGEMENTスレッドプールで実行 | E-01 (80行目) | ○ |
| C-05 | TransportNodesStatsActionはTransportNodesActionを継承 | E-02 (56行目) | ○ |
| C-06 | 27種のメトリクスカテゴリ（NodesStats） | E-02 (105-133行目) | ○ |
| C-07 | NodeService.stats()を呼び出し | E-02 (105行目) | ○ |
| C-08 | FailedNodeExceptionによる部分的失敗処理 | E-01 (36行目 import), E-02 (36行目 import) | ○ |
| C-09 | 画面107-111がノード情報・統計に対応 | E-03 | ○ |
| C-10 | 画面145,153,154がCat系API対応 | E-03 | ○ |
| C-11 | NodesInfoResponseにclusterName, responses, failuresを含む | E-01 (92行目) | ○ |
| C-12 | NodeServiceのinfo()/stats()メソッドの詳細な収集ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- NodeServiceの実装は未確認
  - 候補：`server/src/main/java/org/opensearch/node/NodeService.java`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - トランスポートアクションの構造は確認済み
- 1: 中リスク - NodeServiceの各メトリクス収集の具体的な実装は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] NodeService.info()とNodeService.stats()の実装を確認
- [ ] NodeInfo, NodeStatsのデータ構造が設計書の記載と一致するか確認
- [ ] ノード使用状況（Usage）とホットスレッドのトランスポートアクションを確認
