---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：5-インデックスロールオーバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ISMポリシーからの自動ロールオーバー**：ISM連携の詳細は本ソースコードには含まれない

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/rollover/RolloverRequest.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/rollover/TransportRolloverAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/rollover/MetadataRolloverService.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ターゲットはエイリアスまたはデータストリーム | E-03 (77行目, 403-433行目 validate) | ○ |
| C-02 | 書き込みインデックスが必要 | E-03 (419-421行目) | ○ |
| C-03 | データストリームの場合newIndexName等は指定不可 | E-03 (422-433行目) | ○ |
| C-04 | max_age, max_docs, max_sizeの3条件 | E-01 (71-73行目) | ○ |
| C-05 | dry_runモードで条件評価のみ可能 | E-02 (184-189行目) | ○ |
| C-06 | 条件未設定または条件充足時にロールオーバー実行 | E-02 (195行目) | ○ |
| C-07 | インデックス名自動生成は末尾数値インクリメント6桁ゼロ埋め | E-03 (247-264行目) | ○ |
| C-08 | 同時変更検出でOpenSearchException | E-02 (210-214行目) | ○ |
| C-09 | テンプレート重複チェック | E-03 (363-401行目) | ○ |
| C-10 | エイリアスロールオーバー時のエイリアス切り替え処理 | E-03 (308-356行目) | ○ |
| C-11 | RolloverInfoの記録 | E-03 (194-200行目) | ○ |
| C-12 | ClusterStateUpdateTaskとして実行 | E-02 (196行目) | ○ |
| C-13 | rolloverIndexTaskKeyによるスロットリング | E-02 (115行目, 221行目) | ○ |
| C-14 | activeShardsObserverで待機 | E-02 (232-248行目) | ○ |
| C-15 | evaluateConditionsでドキュメント数とサイズを使用 | E-02 (297-314行目) | ○ |
| C-16 | 画面No48が主画面 | E-04 | ○ |
| C-17 | includeDataStreams()がtrue | E-01 (179-181行目) | ○ |
| C-18 | ISMポリシーからの自動ロールオーバー連携 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ISM（Index State Management）からのロールオーバートリガーは本ソースコードスコープ外
  - 候補：ISMプラグインのソースコード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- コア処理フローはソースコードから詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ISMからのロールオーバー連携の記述が正確か確認
- [ ] データストリームロールオーバーの動作を確認
