---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 14
  claims_without_evidence: 4
confidence_derived: 0.78
---

# 根拠レポート：51-タスク管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.78**
  - 根拠あり：14 / 18、根拠なし：4
- 優先レビュー（高）
  1. **TaskResultStorageの詳細実装**：永続化の具体的な動作は未精査
  2. **Cancel Tasks APIの詳細なキャンセル条件**：ソースコードの部分的読解のみ
  3. **親子タスク関係の詳細処理**：TaskManagerの内部ロジック未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/cluster/tasks/TransportPendingClusterTasksAction.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksRequest.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksResponse.java`
- E-04: `server/src/main/java/org/opensearch/action/admin/cluster/tasks/PendingClusterTasksAction.java`
- E-05: `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/list/ListTasksAction.java`
- E-06: `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/cancel/CancelTasksAction.java`
- E-07: `server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/get/GetTaskAction.java`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pending Cluster TasksのアクションはPendingClusterTasksAction.NAME | E-04 | ○ |
| C-02 | List Tasksのアクション名はcluster:monitor/tasks/lists | E-05 | ○ |
| C-03 | Get Taskのアクション名はcluster:monitor/task/get | E-07 | ○ |
| C-04 | Cancel Tasksのアクション名はcluster:admin/tasks/cancel | E-06 | ○ |
| C-05 | PendingClusterTasksRequestにlocal, clusterManagerNodeTimeoutパラメータが存在 | E-02 | ○ |
| C-06 | PendingClusterTasksResponseにpendingTasksのリストが含まれる | E-03 | ○ |
| C-07 | PendingClusterTaskはsource, priority, timeInQueue等のフィールドを持つ | E-03 | ○ |
| C-08 | TransportPendingClusterTasksActionはClusterServiceからタスク一覧を取得 | E-01 | ○ |
| C-09 | Get Taskはwait_for_completionでタスク完了を待機可能 | E-07（推測） | ○ |
| C-10 | Cancel Tasksはnodes、actions、parent_task_idでフィルタ可能 | E-06（推測） | ○ |
| C-11 | 機能一覧でNo.51がタスク管理として定義されている | E-08 | ○ |
| C-12 | 優先度はIMMediaTE、URGENT、HIGH、NORMAL、LOWが存在 | E-03 | ○ |
| C-13 | TransportClusterManagerNodeReadActionを継承 | E-01 | ○ |
| C-14 | タスクIDはノードIDとタスク番号で構成される | **根拠なし** | △ |
| C-15 | TaskResultStorageにタスク結果が永続化される | **根拠なし** | △ |
| C-16 | 親子タスク関係でキャンセルが伝播する | **根拠なし** | △ |
| C-17 | タイムアウト時にOpenSearchTimeoutExceptionが発生 | **根拠なし** | △ |
| C-18 | 同時実行タスク数の制限がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TaskManager.javaの内部処理（タスク登録・管理ロジック）は未精査
  - 候補：`server/src/main/java/org/opensearch/tasks/TaskManager.java`
- TaskResultStorageの実装詳細は未確認
  - 候補：`server/src/main/java/org/opensearch/tasks/TaskResultsService.java`
- List Tasks, Get Task, Cancel TasksのTransportAction実装は未精査
  - 候補：`server/src/main/java/org/opensearch/action/admin/cluster/node/tasks/`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- Pending Cluster Tasksの基本構造はソースコードから確認済み
- 1: 中リスク -- List/Get/Cancel Tasks APIの詳細パラメータは推測を含む
- 1: 中リスク -- タスク永続化の詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] List Tasks APIのレスポンス構造がOpenSearch公式ドキュメントと一致するか確認
- [ ] Get Task APIのwait_for_completionの動作がソースコードと一致するか確認
- [ ] Cancel Tasks APIのキャンセル条件（キャンセル可能なタスク）を確認
- [ ] タスクID形式（nodeId:taskNumber）の正確性を確認
