---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：54-ノードデコミッション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **クォーラム維持の詳細計算**：半数以下のノードデコミッションの制限ロジック
  2. **リコミッション後のノード再参加フロー**：完全なフローは未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/cluster/decommission/DecommissionService.java`
- E-02: `server/src/main/java/org/opensearch/cluster/decommission/DecommissionController.java`
- E-03: `server/src/main/java/org/opensearch/cluster/decommission/DecommissionAttribute.java`
- E-04: `server/src/main/java/org/opensearch/cluster/decommission/DecommissionAttributeMetadata.java`
- E-05: `server/src/main/java/org/opensearch/cluster/decommission/DecommissionStatus.java`
- E-06: `server/src/main/java/org/opensearch/cluster/decommission/DecommissionHelper.java`
- E-07: `server/src/main/java/org/opensearch/cluster/decommission/DecommissioningFailedException.java`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DecommissionServiceがメインサービスクラス | E-01 | ○ |
| C-02 | startDecommissionAction()でデコミッションを開始 | E-01 (135-300行目) | ○ |
| C-03 | DecommissionStatusはINIT, DRAINING, IN_PROGRESS, SUCCESSFUL, FAILEDの5状態 | E-05 | ○ |
| C-04 | 状態遷移はINIT→DRAINING→IN_PROGRESS→SUCCESSFUL/FAILED | E-05, E-01 | ○ |
| C-05 | drainNodesWithDecommissionedAttribute()でドレイニング処理 | E-01 (304-342行目) | ○ |
| C-06 | failDecommissionedNodes()でノード除外実行 | E-01 (365-412行目) | ○ |
| C-07 | startRecommissionAction()でリコミッション | E-01 (540-571行目) | ○ |
| C-08 | DecommissionControllerがノード除外を実行 | E-02 | ○ |
| C-09 | DecommissionAttributeが属性データ構造を定義 | E-03 | ○ |
| C-10 | DecommissionAttributeMetadataがクラスタメタデータを保持 | E-04 | ○ |
| C-11 | DecommissionHelperがユーティリティを提供 | E-06 | ○ |
| C-12 | DecommissioningFailedExceptionがエラーを表現 | E-07 | ○ |
| C-13 | 重みが0に設定されていることが前提条件 | E-01 | ○ |
| C-14 | VotingConfigExclusionに追加される | E-01 | ○ |
| C-15 | delay_timeoutでドレイニング待機時間を設定 | E-01 | ○ |
| C-16 | デフォルトのドレイニング時間は120秒 | E-01 | ○ |
| C-17 | 機能一覧でNo.54がノードデコミッションとして定義 | E-08 | ○ |
| C-18 | アウェアネス属性が設定済みであることが前提条件 | E-01 | ○ |
| C-19 | クォーラム維持のため半数以下のノードに限定 | **根拠なし** | △ |
| C-20 | リコミッション後にノードが自動的に再参加 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- クォーラム計算の詳細ロジックは未精査
  - 候補：`DecommissionService.java`の検証ロジック部分
- リコミッション後のノード再参加フローは未確認
  - 候補：Coordinator.javaとの連携

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 状態遷移、主要メソッドはソースコードから確認済み
- 0: 低リスク -- エラー処理はDecommissioningFailedExceptionから確認済み
- 1: 中リスク -- クォーラム維持の詳細計算は要確認

## 6) レビュアーチェックリスト（最小）
- [ ] クォーラム維持の計算ロジックがソースコードと一致するか確認
- [ ] リコミッション後のノード再参加フローを確認
- [ ] delay_timeoutのデフォルト値（120秒）が正しいか確認
- [ ] V2.4.0以降で利用可能という記述が正しいか確認
