---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 15
  claims_without_evidence: 3
confidence_derived: 0.83
---

# 根拠レポート：56-シャードアロケーション

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：15 / 18、根拠なし：3
- 優先レビュー（高）
  1. **全AllocationDeciderの詳細ロジック**：主要なDeciderのみ確認
  2. **重み関数の詳細パラメータ**：theta0, theta1の具体的値は未確認
  3. **allocator_timeoutの詳細動作**：タイムアウト時の挙動

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/cluster/routing/allocation/AllocationService.java`
- E-02: `server/src/main/java/org/opensearch/cluster/routing/allocation/RoutingAllocation.java`
- E-03: `server/src/main/java/org/opensearch/cluster/routing/allocation/decider/AllocationDecider.java`
- E-04: `server/src/main/java/org/opensearch/cluster/routing/allocation/decider/AllocationDeciders.java`
- E-05: `server/src/main/java/org/opensearch/cluster/routing/allocation/decider/DiskThresholdDecider.java`
- E-06: `server/src/main/java/org/opensearch/cluster/routing/allocation/allocator/BalancedShardsAllocator.java`
- E-07: `server/src/main/java/org/opensearch/cluster/routing/allocation/allocator/LocalShardsBalancer.java`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AllocationServiceがアロケーションの中核サービス | E-01 | ○ |
| C-02 | reroute()メソッドでアロケーション処理を開始 | E-01 | ○ |
| C-03 | RoutingAllocationがアロケーションコンテキストを保持 | E-02 | ○ |
| C-04 | AllocationDeciderが配置可否を判定する抽象基底クラス | E-03 | ○ |
| C-05 | AllocationDecidersが複数のDeciderを集約 | E-04 | ○ |
| C-06 | DiskThresholdDeciderがディスク閾値を判定 | E-05 | ○ |
| C-07 | 低ウォーターマークのデフォルトは85% | E-05 | ○ |
| C-08 | 高ウォーターマークのデフォルトは90% | E-05 | ○ |
| C-09 | フラッドステージのデフォルトは95% | E-05 | ○ |
| C-10 | BalancedShardsAllocatorがデフォルトのアロケータ | E-06 | ○ |
| C-11 | LocalShardsBalancerがバランシングロジックを実装 | E-07 | ○ |
| C-12 | 機能一覧でNo.56がシャードアロケーションとして定義 | E-08 | ○ |
| C-13 | プライマリシャードはレプリカより先に割り当て | E-01 | ○ |
| C-14 | 同一シャードのプライマリとレプリカは異なるノードに配置 | E-04（推測） | ○ |
| C-15 | cluster:admin/rerouteアクション権限が必要 | E-01 | ○ |
| C-16 | 重み関数はtheta0 * weightShard + theta1 * weightIndex | **根拠なし** | △ |
| C-17 | バランス閾値のデフォルトは1.0 | **根拠なし** | △ |
| C-18 | allocator_timeoutでタイムアウト設定可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 全AllocationDeciderの一覧と詳細ロジックは未網羅
  - 候補：`server/src/main/java/org/opensearch/cluster/routing/allocation/decider/`配下の全ファイル
- BalancedShardsAllocatorの重み計算の詳細は未精査
  - 候補：`BalancedShardsAllocator.java`の重み計算部分
- GatewayAllocatorとの連携詳細は未確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 中核サービス、Decider構造はソースコードから確認済み
- 1: 中リスク -- 全Deciderの網羅的確認は必要
- 1: 中リスク -- 重み計算の詳細パラメータは要確認

## 6) レビュアーチェックリスト（最小）
- [ ] 全AllocationDeciderの一覧と役割を確認
- [ ] 重み関数のパラメータ（theta0, theta1）の具体的値を確認
- [ ] バランス閾値（balance.threshold）のデフォルト値を確認
- [ ] allocator_timeoutの設定と動作を確認
