---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 17
  claims_with_evidence: 14
  claims_without_evidence: 3
confidence_derived: 0.82
---

# 根拠レポート：57-シャードルーティング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.82**
  - 根拠あり：14 / 17、根拠なし：3
- 優先レビュー（高）
  1. **アダプティブレプリカ選択の詳細アルゴリズム**：ノード統計の評価方法
  2. **ResponseCollectorServiceとの連携詳細**：統計収集の仕組み
  3. **全プリファレンスオプションの動作確認**：各オプションの詳細動作

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/cluster/routing/OperationRouting.java`
- E-02: `server/src/main/java/org/opensearch/cluster/routing/Preference.java`
- E-03: `server/src/main/java/org/opensearch/cluster/routing/IndexShardRoutingTable.java`
- E-04: `server/src/main/java/org/opensearch/cluster/routing/Murmur3HashFunction.java`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OperationRouting.javaがメインのルーティングクラス | E-01 | ○ |
| C-02 | Preference列挙型でプリファレンスオプションを定義 | E-02 | ○ |
| C-03 | IndexShardRoutingTableがシャードイテレータを生成 | E-03 | ○ |
| C-04 | Murmur3HashFunctionでシャードIDを計算 | E-04 | ○ |
| C-05 | シャードID計算式はhash(routing) % numberOfShards | E-04 | ○ |
| C-06 | _localプリファレンスでローカルノード優先 | E-02 | ○ |
| C-07 | _primaryプリファレンスでプライマリのみ | E-02 | ○ |
| C-08 | _replicaプリファレンスでレプリカのみ | E-02 | ○ |
| C-09 | _primary_firstプリファレンスでプライマリ優先 | E-02 | ○ |
| C-10 | _replica_firstプリファレンスでレプリカ優先 | E-02 | ○ |
| C-11 | _only_localプリファレンスでローカルのみ | E-02 | ○ |
| C-12 | _only_nodesプリファレンスで指定ノードのみ | E-02 | ○ |
| C-13 | _prefer_nodesプリファレンスで指定ノード優先 | E-02 | ○ |
| C-14 | 機能一覧でNo.57がシャードルーティングとして定義 | E-05 | ○ |
| C-15 | アダプティブレプリカ選択がデフォルト有効 | **根拠なし** | △ |
| C-16 | ResponseCollectorServiceでノード統計を収集 | **根拠なし** | △ |
| C-17 | シャードID計算はO(1)の計算量 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- アダプティブレプリカ選択の詳細実装は未精査
  - 候補：`OperationRouting.java`のアダプティブ選択部分
- ResponseCollectorServiceの統計収集ロジックは未確認
  - 候補：`server/src/main/java/org/opensearch/node/ResponseCollectorService.java`
- _search_replicaプリファレンスの詳細動作は未確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- 基本的なプリファレンスオプションはソースコードから確認済み
- 1: 中リスク -- アダプティブレプリカ選択の詳細は要精査
- 0: 低リスク -- Murmur3ハッシュ関数はシンプルな実装

## 6) レビュアーチェックリスト（最小）
- [ ] アダプティブレプリカ選択のデフォルト設定を確認
- [ ] ResponseCollectorServiceの統計収集方法を確認
- [ ] 全プリファレンスオプションの動作を網羅的にテスト
- [ ] _search_replicaプリファレンスの詳細を確認
