---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：58-重み付きルーティング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **FailAwareWeightedRoutingの詳細実装**：フェイルオープン機能の詳細
  2. **V2.4.0以降で利用可能という記述の検証**：バージョン確認

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/cluster/routing/WeightedRoutingService.java`
- E-02: `server/src/main/java/org/opensearch/cluster/routing/WeightedRouting.java`
- E-03: `server/src/main/java/org/opensearch/cluster/metadata/WeightedRoutingMetadata.java`
- E-04: `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/put/TransportAddWeightedRoutingAction.java`
- E-05: `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/get/TransportGetWeightedRoutingAction.java`
- E-06: `server/src/main/java/org/opensearch/action/admin/cluster/shards/routing/weighted/delete/TransportDeleteWeightedRoutingAction.java`
- E-07: `server/src/main/java/org/opensearch/cluster/routing/UnsupportedWeightedRoutingStateException.java`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | WeightedRoutingServiceがメインサービスクラス | E-01 | ○ |
| C-02 | registerWeightedRoutingMetadata()で重み登録 | E-01 (81-128行目) | ○ |
| C-03 | deleteWeightedRoutingMetadata()で重み削除 | E-01 (130-176行目) | ○ |
| C-04 | WeightedRoutingがattributeNameとweightsを保持 | E-02 | ○ |
| C-05 | WeightedRoutingMetadataがクラスタメタデータとして保存 | E-03 | ○ |
| C-06 | ensureWeightsSetForAllDiscoveredAndForcedAwarenessValues()で全属性値検証 | E-01 (209-252行目) | ○ |
| C-07 | ensureDecommissionedAttributeHasZeroWeight()でデコミッション整合性チェック | E-01 (254-288行目) | ○ |
| C-08 | ensureNoVersionConflict()でバージョン競合チェック | E-01 (290-302行目) | ○ |
| C-09 | 半数を超える属性値に重み0を設定不可 | E-01 (240-251行目) | ○ |
| C-10 | デコミッション中の属性値は重み0必須 | E-01 (254-288行目) | ○ |
| C-11 | UnsupportedWeightedRoutingStateExceptionでエラーを表現 | E-07 | ○ |
| C-12 | ClusterStateUpdateTaskとして実行 | E-01 (88行目) | ○ |
| C-13 | Priority.URGENTで優先度設定 | E-01 (88行目) | ○ |
| C-14 | TransportAddWeightedRoutingActionで重み設定 | E-04 | ○ |
| C-15 | TransportGetWeightedRoutingActionで重み取得 | E-05 | ○ |
| C-16 | TransportDeleteWeightedRoutingActionで重み削除 | E-06 | ○ |
| C-17 | 機能一覧でNo.58が重み付きルーティングとして定義 | E-08 | ○ |
| C-18 | アウェアネス属性として設定済みの属性のみ対象 | E-01 (198-207行目) | ○ |
| C-19 | FailAwareWeightedRoutingでフェイルオープン | **根拠なし** | △ |
| C-20 | V2.4.0以降で利用可能 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- FailAwareWeightedRouting.javaの詳細実装は未精査
  - 候補：`server/src/main/java/org/opensearch/cluster/routing/FailAwareWeightedRouting.java`
- バージョン履歴からのV2.4.0確認は未実施

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク -- メインサービスの実装はソースコードから詳細確認済み
- 0: 低リスク -- バリデーションロジックは詳細に確認済み
- 1: 中リスク -- フェイルオープン機能は要精査

## 6) レビュアーチェックリスト（最小）
- [ ] FailAwareWeightedRoutingのフェイルオープン動作を確認
- [ ] V2.4.0での機能追加をリリースノートで確認
- [ ] REST APIエンドポイントのパス形式を確認
- [ ] バージョン管理（_version）の動作を確認
