---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-インデックスシュリンク/スプリット

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **シュリンク前のread-only設定と同一ノード配置の前提条件**：MetadataCreateIndexServiceの精査が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/shrink/ResizeRequest.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/shrink/TransportResizeAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/shrink/ResizeType.java`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SHRINK/SPLIT/CLONEの3種類 | E-03 | ○ |
| C-02 | ウォームインデックスはリサイズ不可 | E-02 (155-157行目) | ○ |
| C-03 | リモートマイグレーション検証 | E-02 (410-431行目) | ○ |
| C-04 | セグレプ有効時リフレッシュ+レプリケーション確認 | E-02 (160-206行目) | ○ |
| C-05 | MAX_DOCSチェック（シュリンク時） | E-02 (296-311行目) | ○ |
| C-06 | スプリットではシャード数指定が必須 | E-02 (285行目) | ○ |
| C-07 | クローンはソースと同じシャード数 | E-02 (290行目) | ○ |
| C-08 | calculateTargetIndexShardsNumのロジック | E-02 (363-391行目) | ○ |
| C-09 | read_only設定の伝搬チェック | E-02 (271-280行目) | ○ |
| C-10 | soft_deletes無効化禁止 | E-02 (328-332行目) | ○ |
| C-11 | recoverFromで元インデックスを参照 | E-02 (348行目) | ○ |
| C-12 | resizeTypeが設定される | E-02 (349行目) | ○ |
| C-13 | MetadataCreateIndexService.createIndexが呼び出される | E-02 (219行目) | ○ |
| C-14 | maxBytesBehind != 0でエラー | E-02 (183-193行目) | ○ |
| C-15 | 画面No46, 47が主画面 | E-04 | ○ |
| C-16 | シュリンク前にソースがread-only+同一ノード配置が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- シュリンクの前提条件（read-only、同一ノード配置）はMetadataCreateIndexServiceで検証されるが、本スコープでは未精査
  - 候補：`server/src/main/java/org/opensearch/cluster/metadata/MetadataCreateIndexService.java`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク -- シュリンクの前提条件の詳細はMetadataCreateIndexServiceの精査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] シュリンクの前提条件（read-only、同一ノード配置）を確認
- [ ] calculateTargetIndexShardsNumのロジックが正確か確認
