---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：61-リモートストア

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **リトライ仕様の詳細**：具体的なリトライ間隔・最大リトライ回数が不明
  2. **パフォーマンス要件の定量値**：具体的な数値目標が不明

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/index/remote/RemoteStoreEnums.java`
- E-02: `server/src/main/java/org/opensearch/index/remote/RemoteStorePathStrategy.java`
- E-03: `server/src/main/java/org/opensearch/index/remote/RemoteStorePressureService.java`
- E-04: `server/src/main/java/org/opensearch/index/remote/RemoteStorePressureSettings.java`
- E-05: `server/src/main/java/org/opensearch/index/remote/RemoteStoreUtils.java`
- E-06: `server/src/main/java/org/opensearch/index/remote/RemoteSegmentTransferTracker.java`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-08: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DataCategoryにSEGMENTSとTRANSLOGが存在する | E-01 (46-47行目) | ○ |
| C-02 | DataTypeにDATA, METADATA, LOCK_FILESが存在する | E-01 (72-74行目) | ○ |
| C-03 | PathTypeにFIXED, HASHED_PREFIX, HASHED_INFIXが存在する | E-01 (94-137行目) | ○ |
| C-04 | PathHashAlgorithmにFNV_1A_BASE64とFNV_1A_COMPOSITE_1が存在する | E-01 (214-239行目) | ○ |
| C-05 | HASHED_PREFIX/HASHED_INFIXはハッシュアルゴリズムが必須 | E-01 (119-121行目, 134-136行目) | ○ |
| C-06 | RemoteStorePathStrategyはPathTypeとHashAlgorithmの互換性を検証する | E-02 (53-56行目) | ○ |
| C-07 | ShardDataPathInputはbasePath, indexUUID, shardId, dataCategory, dataTypeで構成 | E-02 (229-246行目) | ○ |
| C-08 | バックプレッシャーで3つのLagValidator（ConsecutiveFailure, BytesLag, TimeLag）を使用 | E-03 (48-53行目) | ○ |
| C-09 | BytesLagValidatorはuploadBytesMovingAverage * varianceFactorで閾値を算出 | E-03 (142-144行目) | ○ |
| C-10 | TimeLagValidatorはuploadTimeMovingAverage * varianceFactorで閾値を算出 | E-03 (188-189行目) | ○ |
| C-11 | ConsecutiveFailureValidatorは連続失敗回数と閾値を比較 | E-03 (228-230行目) | ○ |
| C-12 | 閾値超過時にOpenSearchRejectedExecutionExceptionをスロー | E-03 (83行目) | ○ |
| C-13 | RefreshSeqNoLag == 0の場合はバリデーションをスキップ | E-03 (74-76行目) | ○ |
| C-14 | FNV-1aハッシュアルゴリズムを使用 | E-01 (221行目) | ○ |
| C-15 | @ExperimentalApiアノテーションで実験的機能として提供 | E-01 (37行目), E-02 (30行目) | ○ |
| C-16 | 関連画面に「リモートストアリストア」「リモートストア統計」が存在 | E-08 (126-127画面) | ○ |
| C-17 | リトライは自動的にバックグラウンドタスクで行われる | **根拠なし** | △ |
| C-18 | パフォーマンス要件としてホットスポット回避のためハッシュベースパス戦略を使用 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- リトライ仕様の詳細（リトライ間隔、最大回数）はRemoteStorePressureServiceの直接的なコードからは確認できず、上位のセグメント転送ロジックを参照する必要がある
  - 候補：IndexShard / RemoteStoreRefreshListener / BlobStoreTransferService
- パフォーマンス要件の定量的な数値目標はソースコードからは読み取れない
  - 候補：設計書 / ベンチマーク結果 / ドキュメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造とパス戦略の記述（ソースコードから直接確認可能）
- 0: 低リスク - バックプレッシャー検証ロジック（ソースコードから直接確認可能）
- 1: 中リスク - リトライ仕様（上位モジュールの確認が必要）
- 1: 中リスク - パフォーマンス要件（定量的な根拠が不足）

## 6) レビュアーチェックリスト（最小）
- [ ] バックプレッシャー検証の3つのバリデータの閾値算出ロジックが正しいか確認
- [ ] PathType列挙型のgeneratePathメソッドの実装がドキュメントの記述と一致するか確認
- [ ] リモートストアの設定パラメータ一覧が最新のソースコードと一致するか確認
- [ ] リトライ仕様について上位モジュールの実装を追加調査
