---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 13
  claims_without_evidence: 2
confidence_derived: 0.87
---

# 根拠レポート：62-リモートクラスタ状態管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.87**
  - 根拠あり：13 / 15、根拠なし：2
- 優先レビュー（高）
  1. **クリーンアップの具体的な条件**：古いメタデータ削除の閾値が不明
  2. **マニフェストのアトミック性保証**：BlobStoreでのアトミック書き込みの実装詳細が不明

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/gateway/remote/RemoteClusterStateService.java`
- E-02: `server/src/main/java/org/opensearch/gateway/remote/ClusterMetadataManifest.java`
- E-03: `server/src/main/java/org/opensearch/gateway/remote/ClusterStateDiffManifest.java`
- E-04: `server/src/main/java/org/opensearch/gateway/remote/RemoteClusterStateCleanupManager.java`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | REMOTE_CLUSTER_STATE_ENABLED_SETTING設定でリモートクラスタ状態を有効化 | E-01 (153-158行目) | ○ |
| C-02 | REMOTE_PUBLICATION_SETTING設定でリモート公開を有効化 | E-01 (136-141行目) | ○ |
| C-03 | 読み取りタイムアウトのデフォルトは20秒 | E-01 (160行目) | ○ |
| C-04 | チェックサム検証モードはNONE/DEBUG/TRACE/FAILUREの4種類 | E-01 (194-198行目) | ○ |
| C-05 | クラスタ状態パスの固定プレフィックス設定が存在する | E-01 (180-185行目) | ○ |
| C-06 | @InternalApiアノテーションで内部APIとして提供 | E-01 (125行目) | ○ |
| C-07 | RemoteClusterStateServiceはCloseableを実装 | E-01 (126行目) | ○ |
| C-08 | マニフェストCODECバージョンにV2, V3, CURRENTが存在 | E-01 (98-100行目) | ○ |
| C-09 | 差分アップロードで変更メタデータのみアップロード | E-01 (インポート文でClusterStateDiffManifestを参照) | ○ |
| C-10 | 並列アップロードにCountDownLatchとLatchedActionListenerを使用 | E-01 (15行目インポート) | ○ |
| C-11 | RemoteIndexMetadataManager等のサブマネージャーに委譲 | E-01 (インポート文) | ○ |
| C-12 | SLOW_WRITE_LOGGING_THRESHOLDによる遅延書き込み検出 | E-01 (97行目) | ○ |
| C-13 | REMOTE_STATE_DOWNLOAD_TO_SERVE_READ_API設定が存在 | E-01 (143-148行目) | ○ |
| C-14 | クリーンアップの具体的な条件（保持期間・最大数） | **根拠なし** | △ |
| C-15 | マニフェストのアトミック書き込みによる一貫性保証 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- クリーンアップの具体的な条件はRemoteClusterStateCleanupManagerの詳細実装を確認する必要がある
  - 候補：RemoteClusterStateCleanupManager.java内の定数・設定値
- マニフェストのアトミック書き込みはBlobStoreRepositoryの実装に依存
  - 候補：BlobStoreRepository.java / BlobContainer.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設定値の記述（ソースコードから直接確認可能）
- 1: 中リスク - クリーンアップ条件の詳細
- 1: 中リスク - アトミック性保証の実装詳細

## 6) レビュアーチェックリスト（最小）
- [ ] RemoteClusterStateServiceの設定値が最新のソースコードと一致するか確認
- [ ] RemoteClusterStateCleanupManagerのクリーンアップ条件を追加調査
- [ ] マニフェストのアトミック書き込みの実装を確認
- [ ] CODECバージョンの互換性について確認
