---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：7-インデックステンプレート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **V2テンプレートがV1より優先される動作**：MetadataIndexTemplateServiceの内部ロジック未精査
  2. **コンポーネントテンプレートの合成ロジック**：MetadataIndexTemplateServiceの内部ロジック未精査

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/template/put/PutIndexTemplateRequest.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/template/put/TransportPutIndexTemplateAction.java`
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-04: ディレクトリ構造（put/, get/, delete/, post/サブディレクトリ）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | name, patterns, order, settings, mappings, aliasesフィールドが存在 | E-01 (92-100行目) | ○ |
| C-02 | METADATA_WRITEグローバルブロックチェック | E-02 (108-110行目) | ○ |
| C-03 | IndexScopedSettings.validate()で設定バリデーション | E-02 (124行目) | ○ |
| C-04 | マッピングトランスフォーマーが適用される | E-02 (152行目) | ○ |
| C-05 | MetadataIndexTemplateService.putTemplate()が呼ばれる | E-02 (127行目) | ○ |
| C-06 | 3種類のテンプレート（V1, V2, コンポーネント）が存在 | E-04 (ディレクトリ構造) | ○ |
| C-07 | シミュレーション機能が存在 | E-04 (post/ディレクトリ) | ○ |
| C-08 | 画面No61-74, 164が関連 | E-03 | ○ |
| C-09 | causeが空の場合"api"に設定 | E-02 (118-121行目) | ○ |
| C-10 | Settings正規化（INDEX_SETTING_PREFIX付加） | E-02 (123行目) | ○ |
| C-11 | createフラグで上書き制御 | E-02 (133行目) | ○ |
| C-12 | versionフィールドが存在 | E-02 (135行目) | ○ |
| C-13 | V2テンプレートがV1より優先される | **根拠なし** | △ |
| C-14 | コンポーネントテンプレートの合成ロジック | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- V2テンプレートの優先ロジックとコンポーネントテンプレートの合成ロジックはMetadataIndexTemplateServiceの精査が必要
  - 候補：`server/src/main/java/org/opensearch/cluster/metadata/MetadataIndexTemplateService.java`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク -- テンプレート優先順位と合成ロジックの詳細はMetadataIndexTemplateServiceの精査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] V1/V2テンプレートの優先順位ロジックを確認
- [ ] コンポーネントテンプレートの合成ロジックを確認
- [ ] 各種テンプレート操作のアクション名が正確か確認
