---
generated_at: 2026-02-03 11:30:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：70-共通アナライザ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 全主張に根拠あり。プリビルトアナライザの完全な一覧を確認することを推奨。

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/CommonAnalysisModulePlugin.java`
- E-02: `modules/analysis-common/src/main/java/org/opensearch/analysis/common/AnalysisPredicateScript.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CommonAnalysisModulePluginはPlugin、AnalysisPlugin、ScriptPluginを実装 | E-01 (174行目) | ○ |
| C-02 | AnalysisPredicateScript.CONTEXTをスクリプトコンテキストとして登録 | E-01 (200行目) | ○ |
| C-03 | getAnalyzers()でfingerprint、pattern、snowball等を登録 | E-01 (204-248行目) | ○ |
| C-04 | 30以上の言語アナライザを提供（Arabic〜Thai） | E-01 (211-246行目) | ○ |
| C-05 | getTokenFilters()で50以上のフィルタを登録 | E-01 (251行目以降) | ○ |
| C-06 | edgeNGramはV3.0.0以降でIllegalArgumentException | E-01 (275-289行目) | ○ |
| C-07 | nGramはdeprecation警告を出力 | E-01 (309-316行目) | ○ |
| C-08 | requiresAnalysisSettingsで設定必須フィルタを指定 | E-01 (263, 272, 290等) | ○ |
| C-09 | ScriptedConditionTokenFilterFactoryがscriptServiceを使用 | E-01 (267行目) | ○ |
| C-10 | DutchStemmer、FrenchStemmerのインポート（Snowball統合） | E-01 (169-170行目) | ○ |
| C-11 | SetOnce<ScriptService>でスクリプトサービスを保持 | E-01 (178行目) | ○ |
| C-12 | 関連画面に55（アナライズ）が存在 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] getTokenFilters()の全フィルタ名が最新のソースコードと一致するか確認
- [ ] getTokenizers()の全トークナイザ名を確認
- [ ] getPreBuiltAnalyzerProviderFactories()のプリビルトアナライザ一覧を確認
- [ ] V3.0.0での非推奨名の扱いが正しいか確認
