---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-ICUアナライザ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **パフォーマンス要件**：具体的な性能値の根拠なし
  2. **ICU Collation Keyword Field Mapper詳細**：マッパーの詳細仕様は設計書で簡略化

## 2) 参照した情報（Evidence一覧）
- E-01: `plugins/analysis-icu/src/main/java/org/opensearch/plugin/analysis/icu/AnalysisICUPlugin.java`
- E-02: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuAnalyzerProvider.java`
- E-03: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuTokenizerFactory.java`
- E-04: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuNormalizerTokenFilterFactory.java`
- E-05: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuFoldingTokenFilterFactory.java`
- E-06: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuTransformTokenFilterFactory.java`
- E-07: `plugins/analysis-icu/src/main/java/org/opensearch/index/analysis/IcuCollationTokenFilterFactory.java`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnalysisICUPluginはAnalysisPluginとMapperPluginを実装 | E-01 63行目 | ○ |
| C-02 | icu_normalizer CharFilterを提供 | E-01 66行目 | ○ |
| C-03 | icu_normalizer, icu_folding, icu_collation, icu_transformの4つのTokenFilterを提供 | E-01 70-76行目 | ○ |
| C-04 | icu_analyzerアナライザを提供 | E-01 81行目 | ○ |
| C-05 | icu_tokenizerトークナイザを提供 | E-01 86行目 | ○ |
| C-06 | デフォルト正規化方式はnfkc_cf | E-02 53行目, E-04 53行目 | ○ |
| C-07 | デフォルトモードはcompose | E-02 54行目 | ○ |
| C-08 | modeはcomposeまたはdecomposeのみ許可 | E-02 55-58行目 | ○ |
| C-09 | unicode_set_filter指定時はFilteredNormalizer2でラップ | E-04 63-72行目 | ○ |
| C-10 | rule_filesは"code:rulefile"形式 | E-03 84-86行目 | ○ |
| C-11 | IcuTransformはデフォルトid=Null, dir=forward | E-06 50-52行目 | ○ |
| C-12 | 照合のstrengthはprimary/secondary/tertiary/quaternary/identical | E-07 114-128行目 | ○ |
| C-13 | IcuAnalyzerはICUNormalizer2CharFilter + ICUTokenizer + ICUFoldingFilterで構成 | E-02 69-83行目 | ○ |
| C-14 | ルールファイルはconfigディレクトリから読み込み | E-03 123行目, E-07 75行目 | ○ |
| C-15 | ICUCollationKeywordFieldMapperをマッパーとして登録 | E-01 90-92行目 | ○ |
| C-16 | IcuFoldingはUTR#30ベースの正規化 | E-05 57-61行目 | ○ |
| C-17 | パフォーマンス要件としてバルクインデックス時の並列処理 | **根拠なし** | △ |
| C-18 | 画面No.55のアナライズ画面と関連 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の具体的な数値はソースコードからは特定できない
  - 候補：ベンチマークテスト / 運用ドキュメント / パフォーマンステスト結果
- ICUCollationKeywordFieldMapperの詳細仕様は本設計書の範囲外
  - 候補：マッパー関連の機能設計書を参照

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プラグインの基本構造と提供コンポーネントは全てソースコードで確認済み
- 1: 中リスク - パフォーマンス要件は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] ICU4Jバージョンとの互換性が正しく記載されているか確認
- [ ] 全てのトークンフィルタの設定パラメータが網羅されているか確認
- [ ] ICUCollationKeywordFieldMapperの詳細が必要かどうか判断
