---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：72-日本語アナライザ（Kuromoji）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **Viterbiアルゴリズムに関する記述**：Lucene内部実装の詳細

## 2) 参照した情報（Evidence一覧）
- E-01: `plugins/analysis-kuromoji/src/main/java/org/opensearch/plugin/analysis/kuromoji/AnalysisKuromojiPlugin.java`
- E-02: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiTokenizerFactory.java`
- E-03: `plugins/analysis-kuromoji/src/main/java/org/opensearch/index/analysis/KuromojiAnalyzerProvider.java`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | プラグインはAnalysisPluginを実装 | E-01 60行目 | ○ |
| C-02 | CharFilter x1（kuromoji_iteration_mark）を提供 | E-01 63行目 | ○ |
| C-03 | TokenFilter x7を提供 | E-01 67-77行目 | ○ |
| C-04 | Tokenizer x1（kuromoji_tokenizer）を提供 | E-01 81行目 | ○ |
| C-05 | Analyzer x2（kuromoji, kuromoji_completion）を提供 | E-01 85-90行目 | ○ |
| C-06 | user_dictionaryとuser_dictionary_rulesの同時指定は不可 | E-02 92-96行目 | ○ |
| C-07 | ユーザー辞書の重複エントリはエラー | E-02 85-87行目 | ○ |
| C-08 | modeはsearch/normal/extendedの3種類 | E-02 125-131行目 | ○ |
| C-09 | デフォルトモードはJapaneseTokenizer.DEFAULT_MODE | E-02 122行目 | ○ |
| C-10 | discard_punctuationのデフォルトはtrue | E-02 74行目 | ○ |
| C-11 | discard_compound_tokenのデフォルトはfalse | E-02 77行目 | ○ |
| C-12 | デフォルトストップワードはJapaneseAnalyzer.getDefaultStopSet() | E-03 51行目 | ○ |
| C-13 | N-best計算はnbest_examplesとnbest_costのmax値 | E-02 140-142行目 | ○ |
| C-14 | JapaneseTokenizer生成時にuserDictionary, discardPunctuation, discardCompoundToken, modeを指定 | E-02 138行目 | ○ |
| C-15 | ユーザー辞書読み込み失敗時はOpenSearchException | E-02 117行目 | ○ |
| C-16 | ViterbiアルゴリズムベースのMeCab辞書参照 | **根拠なし**（Lucene内部実装） | △ |

## 4) 不足情報（Unknown / Missing）
- Viterbiアルゴリズムの詳細はLucene Kuromoji内部実装に依存
  - 候補：Apache Lucene Kuromojiソースコード / MeCab文献

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - プラグイン構造と全コンポーネントは確認済み
- 0: 低リスク - 設定パラメータは全てソースコードから確認

## 6) レビュアーチェックリスト（最小）
- [ ] 全7つのTokenFilterの設定パラメータが正しいか確認
- [ ] ユーザー辞書のCSV形式が正しく記載されているか確認
- [ ] kuromoji_completionアナライザの詳細仕様が必要かどうか判断
