---
generated_at: 2026-02-03 10:10:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：73-韓国語アナライザ（Nori）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `plugins/analysis-nori/src/main/java/org/opensearch/plugin/analysis/nori/AnalysisNoriPlugin.java`
- E-02: `plugins/analysis-nori/src/main/java/org/opensearch/index/analysis/NoriTokenizerFactory.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AnalysisNoriPluginはAnalysisPluginを実装 | E-01 53行目 | ○ |
| C-02 | TokenFilter x3（nori_part_of_speech, nori_readingform, nori_number）を提供 | E-01 55-61行目 | ○ |
| C-03 | Tokenizer x1（nori_tokenizer）を提供 | E-01 65行目 | ○ |
| C-04 | Analyzer x1（nori）を提供 | E-01 70行目 | ○ |
| C-05 | user_dictionaryとuser_dictionary_rulesの同時指定は不可 | E-02 68-71行目 | ○ |
| C-06 | decompound_mode未指定時はKoreanTokenizer.DEFAULT_DECOMPOUND | E-02 90行目 | ○ |
| C-07 | discard_punctuationのデフォルトはtrue | E-02 64行目 | ○ |
| C-08 | ユーザー辞書読み込み失敗時はOpenSearchException | E-02 85行目 | ○ |
| C-09 | decompound_modeはtoUpperCase後にvalueOf変換 | E-02 93行目 | ○ |
| C-10 | CharFilterは提供しない | E-01（getCharFilters未定義） | ○ |
| C-11 | KoreanTokenizer生成時にuserDictionary, decompoundMode, discardPunctuationを指定 | E-02 99-106行目 | ○ |
| C-12 | 機能一覧CSV No.73に記載 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] DecompoundModeの値（NONE/DISCARD/MIXED）の説明が十分か確認
- [ ] NoriAnalyzerProviderの詳細パラメータが必要か確認
