---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：79-Painlessスクリプト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **コンパイルパイプラインの詳細フェーズ順序**：Compiler.javaの全コード読み込みが必要
  2. **スクリプトキャッシュの仕組み**：ScriptServiceの実装詳細

## 2) 参照した情報（Evidence一覧）
- E-01: `modules/lang-painless/src/main/java/org/opensearch/painless/PainlessModulePlugin.java`
- E-02: `modules/lang-painless/src/main/java/org/opensearch/painless/PainlessScriptEngine.java`
- E-03: `modules/lang-painless/src/main/java/org/opensearch/painless/Compiler.java`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PainlessModulePluginはScriptPlugin, ExtensiblePlugin, ActionPluginを実装 | E-01 87行目 | ○ |
| C-02 | NAME="painless" | E-02 72行目 | ○ |
| C-03 | コンテキスト毎にCompilerとPainlessLookupを管理 | E-02 91-100行目 | ○ |
| C-04 | UNTRUSTED_CODEBASEのCodeSourceで実行 | E-03 74-80行目 | ○ |
| C-05 | MovingFunction, Score, Ingest, Update, DerivedFieldの5コンテキストに専用Allowlist | E-01 98-127行目 | ○ |
| C-06 | ContextAwareGroupingScriptにはBASE_ALLOWLISTS | E-01 125行目 | ○ |
| C-07 | REGEX_ENABLEDとREGEX_LIMIT_FACTORの2つの設定 | E-01 168行目 | ○ |
| C-08 | PainlessExecuteActionとPainlessContextActionの2つのアクション | E-01 189-192行目 | ○ |
| C-09 | loadExtensions()でPainlessExtensionからAllowlistを拡張 | E-01 172-180行目 | ○ |
| C-10 | getContexts()でPainlessTestScript.CONTEXTを返す | E-01 184行目 | ○ |
| C-11 | PainlessScriptEngineのコンストラクタでdefaultCompilerSettingsを設定 | E-02 88-89行目 | ○ |
| C-12 | PainlessLookupBuilderでAllowlistからLookupを構築 | E-02 96行目 | ○ |
| C-13 | Compilerのインポート: Walker, PainlessSemanticAnalysisPhase等の各フェーズ | E-03 37-48行目 | ○ |
| C-14 | 画面No.142,143,144と関連 | E-05 | ○ |
| C-15 | 画面No.10（ドキュメント更新）と補助機能として関連 | E-05 | ○ |
| C-16 | PainlessExecuteAction.RestAction, PainlessContextAction.RestActionの2つのRESTハンドラ | E-01 206-208行目 | ○ |
| C-17 | コンパイルパイプラインのフェーズ順序（ANTLR→セマンティック→最適化→IR→バイトコード） | **根拠不足**（Compiler.java全体の読み込みが必要） | △ |
| C-18 | コンパイル済みクラスのキャッシュ | **根拠なし**（ScriptService実装に依存） | △ |

## 4) 不足情報（Unknown / Missing）
- Compiler.javaのcompile()メソッドの全体を読み込む必要がある（今回は先頭80行のみ確認）
  - 候補：Compiler.java全体 / phase/ディレクトリ内の各フェーズクラス
- ScriptServiceのキャッシュ機構はPainlessモジュール外に存在
  - 候補：server/src/main/java/org/opensearch/script/ScriptService.java

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - コンパイルパイプラインの詳細フェーズ順序はCompiler.javaの全コード確認が必要
- 0: 低リスク - プラグイン構造とAllowlist設定は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Compiler.javaのcompile()メソッドでフェーズ順序を確認
- [ ] 各コンテキスト用Allowlistファイル（.txt）の内容が正しいか確認
- [ ] セキュリティ制御（Allowlist、UNTRUSTED_CODEBASE）の記述が十分か確認
