---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：8-データストリーム

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **バッキングインデックスの命名フォーマット詳細**：DataStream.javaの精査が必要
  2. **データストリーム削除時のバッキングインデックス削除動作**：DeleteDataStreamActionの精査が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/datastream/CreateDataStreamAction.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/rollover/MetadataRolloverService.java`（データストリームロールオーバー部分）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名はindices:admin/data_stream/create | E-01 (73行目) | ○ |
| C-02 | nameフィールドのみでリクエスト | E-01 (87-88行目) | ○ |
| C-03 | nameが空の場合バリデーションエラー | E-01 (94-99行目) | ○ |
| C-04 | METADATA_WRITEグローバルブロックチェック | E-01 (183-185行目) | ○ |
| C-05 | MetadataCreateDataStreamService.createDataStreamが呼ばれる | E-01 (179行目) | ○ |
| C-06 | データストリームロールオーバーでhidden=trueのバッキングインデックス作成 | E-02 (271行目) | ○ |
| C-07 | ロールオーバー時にsettings/mappings/aliases指定不可 | E-02 (426-433行目) | ○ |
| C-08 | 画面No75-78が関連 | E-03 | ○ |
| C-09 | IndicesOptions.strictSingleIndexNoExpandForbidClosed使用 | E-01 (132-134行目) | ○ |
| C-10 | resolveIndicesでnameをそのまま返却 | E-01 (188-189行目) | ○ |
| C-11 | バッキングインデックス名のフォーマット | **根拠なし** | △ |
| C-12 | データストリーム削除でバッキングインデックスも削除 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- DataStream.javaの精査（バッキングインデックスの命名規則、ロールオーバー時の世代管理）
  - 候補：`server/src/main/java/org/opensearch/cluster/metadata/DataStream.java`
- DeleteDataStreamAction.javaの精査
  - 候補：`server/src/main/java/org/opensearch/action/admin/indices/datastream/DeleteDataStreamAction.java`

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク -- データストリームのバッキングインデックス管理の詳細はDataStream.javaの精査が必要

## 6) レビュアーチェックリスト（最小）
- [ ] DataStream.javaのバッキングインデックス命名規則を確認
- [ ] データストリーム削除時のバッキングインデックス削除動作を確認
- [ ] MetadataCreateDataStreamServiceのテンプレート検索ロジックを確認
