---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：80-Mustacheテンプレート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **ScriptServiceのキャッシュ機構**：モジュール外の実装

## 2) 参照した情報（Evidence一覧）
- E-01: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/MustacheModulePlugin.java`
- E-02: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/MustacheScriptEngine.java`
- E-03: `modules/lang-mustache/src/main/java/org/opensearch/script/mustache/TransportSearchTemplateAction.java`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MustacheModulePluginはScriptPlugin, ActionPlugin, SearchPluginを実装 | E-01 57行目 | ○ |
| C-02 | NAME="mustache" | E-02 69行目 | ○ |
| C-03 | TemplateScript.CONTEXTのみサポート | E-02 80-82行目, 96-98行目 | ○ |
| C-04 | 3つのAction（SearchTemplate, MultiSearchTemplate, RenderSearchTemplate）を登録 | E-01 65-71行目 | ○ |
| C-05 | 3つのRestHandler（RestSearchTemplateAction, RestMultiSearchTemplateAction, RestRenderSearchTemplateAction）を登録 | E-01 83-88行目 | ○ |
| C-06 | compile()でMustacheオブジェクトを生成 | E-02 83-91行目 | ○ |
| C-07 | MustacheExecutableScript.execute()でtemplate.execute(writer, params) | E-02 131-141行目 | ○ |
| C-08 | AccessController.doPrivileged()内で実行 | E-02 136行目 | ○ |
| C-09 | SpecialPermission.check()によるセキュリティチェック | E-02 135行目 | ○ |
| C-10 | content_typeオプションでCustomMustacheFactoryを切替 | E-02 100-105行目 | ○ |
| C-11 | convert()でテンプレートをレンダリングしSearchRequestに変換 | E-03 136-169行目 | ○ |
| C-12 | simulate=true時はnullを返却 | E-03 153-155行目 | ○ |
| C-13 | ScriptType.STORED時はテンプレート言語をnullに設定 | E-03 144行目 | ○ |
| C-14 | checkRestTotalHitsAsInt()で整合性チェック | E-03 171-192行目 | ○ |
| C-15 | 画面No.26, 27, 28と主機能として関連 | E-05 | ○ |
| C-16 | 画面No.143と補助機能として関連 | E-05 | ○ |
| C-17 | MustacheScriptEngine.getScriptEngine()でMustacheScriptEngineを返す | E-01 60-62行目 | ○ |
| C-18 | コンパイル結果のキャッシュ | **根拠なし**（ScriptService実装） | △ |

## 4) 不足情報（Unknown / Missing）
- ScriptServiceのキャッシュ機構はモジュール外に存在
  - 候補：server/src/main/java/org/opensearch/script/ScriptService.java
- CustomMustacheFactoryのJSON/URLエンコーディング詳細
  - 候補：CustomMustacheFactory.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モジュール構造と主要処理フローは確認済み
- 0: 低リスク - REST API定義は明確

## 6) レビュアーチェックリスト（最小）
- [ ] CustomMustacheFactoryのエンコーディング処理が正しく記載されているか確認
- [ ] MultiSearchTemplateActionの並列実行仕様が必要か確認
- [ ] ストアドスクリプトとの連携が正しく記載されているか確認
