---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：81-Expressionスクリプト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件のJITコンパイル言及**：具体的なベンチマーク根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ExpressionModulePlugin.java`
- E-02: `modules/lang-expression/src/main/java/org/opensearch/script/expression/ExpressionScriptEngine.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 81行目
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 182行目
- E-05: `modules/lang-expression/src/main/java/org/opensearch/script/expression/NumericField.java`
- E-06: `modules/lang-expression/src/main/java/org/opensearch/script/expression/DateField.java`
- E-07: `modules/lang-expression/src/main/java/org/opensearch/script/expression/GeoField.java`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ExpressionはJavaScript風の数式構文を使用する | E-02 (JavascriptCompiler.compile, 179行目) | ○ |
| C-02 | 7つのScriptContextをサポート | E-02 (staticブロック 84-164行目) | ○ |
| C-03 | NAME="expression" | E-02 (80行目) | ○ |
| C-04 | ExpressionModulePluginがScriptPluginを実装 | E-01 (43行目) | ○ |
| C-05 | SpecialPermission.check()でセキュリティチェック | E-02 (175行目) | ○ |
| C-06 | AccessController.doPrivilegedでコンパイル | E-02 (176行目) | ○ |
| C-07 | doc['field']で参照可能なフィールドはnumeric, date, geopointのみ | E-02 (506行目, ParseException) | ○ |
| C-08 | paramsは数値型のみ | E-02 (519-523行目, bindFromParams) | ○ |
| C-09 | FilterScriptは0.0以外でtrue | E-02 (360行目) | ○ |
| C-10 | isResultDeterministicはtrueを返す | E-02 (101, 118, 137, 147, 159行目) | ○ |
| C-11 | 変数バインディングでVariableContext.parseを使用 | E-02 (424行目) | ○ |
| C-12 | GeoPointフィールドのサポート | E-02 (475-481行目), E-07 | ○ |
| C-13 | DateFieldとDateObjectの両方をサポート | E-02 (482-497行目), E-06 | ○ |
| C-14 | 画面No.143でExpression言語情報を提供 | E-04 | ○ |
| C-15 | 機能一覧のカテゴリは「スクリプティング」 | E-03 | ○ |
| C-16 | BucketAggregationSelectorScriptは1.0でtrue | E-02 (93行目) | ○ |
| C-17 | _value変数はPerThreadReplaceableConstDoubleValueSource | E-02 (310-311行目, 382-384行目) | ○ |
| C-18 | PainlessよりもJITコンパイルの恩恵を受けやすく高速 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18のパフォーマンス比較について、コード上には明確なベンチマーク根拠がない。Lucene Expressionのバイトコードコンパイル機構は確認できるが、「Painlessより高速」という主張は一般的な知識に基づく。
  - 候補：OpenSearch公式ドキュメント / Lucene Expressionのパフォーマンスドキュメント / ベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い
- 1: 中リスク - パフォーマンス比較の主張はコード外の知識に依存

## 6) レビュアーチェックリスト（最小）
- [ ] Expression言語がサポートする7つのコンテキストの記載が正確か確認
- [ ] getDocValueSource()のフィールド型制約の記載が正確か確認
- [ ] パフォーマンスに関する記述が適切か確認（ベンチマークデータがあれば補完）
