---
generated_at: 2026-02-03 10:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：82-ストアドスクリプト

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/TransportPutStoredScriptAction.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/TransportDeleteStoredScriptAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/TransportGetScriptLanguageAction.java`
- E-04: `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/PutStoredScriptRequest.java`
- E-05: `server/src/main/java/org/opensearch/action/admin/cluster/storedscripts/GetStoredScriptResponse.java`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` 82行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IDは必須で空文字不可 | E-04 (99-100行目) | ○ |
| C-02 | IDに"#"を含めない | E-04 (101-102行目) | ○ |
| C-03 | contentはPUT時に必須 | E-04 (105-107行目) | ○ |
| C-04 | PUT時METADATA_WRITEブロックチェック | E-01 (108-110行目) | ○ |
| C-05 | DELETE時METADATA_WRITEブロックチェック | E-02 (108-110行目) | ○ |
| C-06 | PUT操作はScriptService.putStoredScriptに委譲 | E-01 (104行目) | ○ |
| C-07 | DELETE操作はScriptService.deleteStoredScriptに委譲 | E-02 (104行目) | ○ |
| C-08 | 言語一覧はScriptService.getScriptLanguagesに委譲 | E-03 (59行目) | ○ |
| C-09 | GetStoredScriptResponseはfound=falseで404 | E-05 (121行目) | ○ |
| C-10 | PUTはTransportClusterManagerNodeActionを継承 | E-01 (60行目) | ○ |
| C-11 | putScriptTaskKeyでスロットリング登録 | E-01 (85行目) | ○ |
| C-12 | deleteScriptTaskKeyでスロットリング登録 | E-02 (85行目) | ○ |
| C-13 | 画面No.139-141が関連 | E-06 (176-178行目) | ○ |
| C-14 | カテゴリは「スクリプティング」 | E-07 | ○ |
| C-15 | ThreadPool.Names.SAMEで実行 | E-01 (90行目), E-02 (90行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ScriptServiceの内部実装（putStoredScript/deleteStoredScript）の詳細が必要か確認
- [ ] REST APIエンドポイントのパス表記が正確か確認
