---
generated_at: 2026-02-03 10:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：84-KMS暗号化

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/CryptoKmsPlugin.java`
- E-02: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsService.java`
- E-03: `plugins/crypto-kms/src/main/java/org/opensearch/crypto/kms/KmsClientSettings.java`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 84行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PROVIDER_NAME="aws-kms" | E-01 (27行目) | ○ |
| C-02 | CryptoKeyProviderPluginとReloadablePluginを実装 | E-01 (26行目) | ○ |
| C-03 | createKeyProviderでKmsService.createMasterKeyProviderに委譲 | E-01 (49-51行目) | ○ |
| C-04 | コンストラクタでreload呼出 | E-01 (45行目) | ○ |
| C-05 | key_arn設定が必須 | E-02 (248-249行目) | ○ |
| C-06 | encryption_contextはカンマ区切りのName=Value形式 | E-02 (254-261行目) | ○ |
| C-07 | リトライポリシーで最大10回 | E-02 (147行目) | ○ |
| C-08 | clientsCacheでKMSクライアントをキャッシュ | E-02 (57行目, 156-176行目) | ○ |
| C-09 | synchronizedでクライアントキャッシュの排他制御 | E-02 (164行目) | ○ |
| C-10 | 参照カウント（tryIncRef/incRef/decRef） | E-02 (160, 172-173行目) | ○ |
| C-11 | refreshAndClearCacheでキャッシュクリア | E-02 (208-214行目) | ○ |
| C-12 | setDefaultAwsProfilePathでパス制限 | E-02 (234-242行目) | ○ |
| C-13 | SpecialPermission.check | E-01 (30行目) | ○ |
| C-14 | getSettings()で12の設定を定義 | E-01 (59-73行目) | ○ |
| C-15 | クライアント接続テスト実行 | E-02 (267-269行目) | ○ |
| C-16 | KmsMasterKeyProviderを返却 | E-02 (271行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] AWS認証情報の設定方法が運用ドキュメントと整合しているか確認
- [ ] KmsMasterKeyProviderの暗号化・復号化処理の詳細が必要か確認
