---
generated_at: 2026-02-03 10:20:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：85-アイデンティティ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/identity/IdentityService.java`
- E-02: `server/src/main/java/org/opensearch/identity/Subject.java`
- E-03: `server/src/main/java/org/opensearch/identity/tokens/TokenManager.java`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 85行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IdentityPluginは0個でNoopIdentityPlugin | E-01 (38-40行目) | ○ |
| C-02 | IdentityPlugin1個で指定プラグイン | E-01 (41-43行目) | ○ |
| C-03 | IdentityPlugin2個以上でOpenSearchException | E-01 (44-48行目) | ○ |
| C-04 | getCurrentSubjectで委譲 | E-01 (55-57行目) | ○ |
| C-05 | getTokenManagerで委譲 | E-01 (62-64行目) | ○ |
| C-06 | initializeIdentityAwarePluginsでPluginSubject割当 | E-01 (66-73行目) | ○ |
| C-07 | Subject.getPrincipalとrunAsの2メソッド | E-02 (24, 29-31行目) | ○ |
| C-08 | runAsデフォルト実装はそのまま実行 | E-02 (29-31行目) | ○ |
| C-09 | TokenManagerにissueOnBehalfOfTokenとissueServiceAccountToken | E-03 (28, 36行目) | ○ |
| C-10 | @ExperimentalApiアノテーション | E-02 (18行目), E-03 (19行目) | ○ |
| C-11 | @InternalApiアノテーション | E-01 (28行目) | ○ |
| C-12 | @PublicApi(since="2.14.0")ではない | E-01, E-02 | ○ |
| C-13 | カテゴリは「セキュリティ」 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] NoopIdentityPluginの具体的な動作を確認（認証なし状態の影響）
- [ ] @ExperimentalApiの使用上の注意がドキュメントに反映されているか確認
