---
generated_at: 2026-02-03 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：86-追加マッパー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/MapperExtrasModulePlugin.java`
- E-02: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/ScaledFloatFieldMapper.java`
- E-03: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/TokenCountFieldMapper.java`
- E-04: `modules/mapper-extras/src/main/java/org/opensearch/index/mapper/SearchAsYouTypeFieldMapper.java`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 86行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 5つのマッパーを登録 | E-01 (49-57行目) | ○ |
| C-02 | RankFeatureMetaFieldMapperをメタフィールドとして登録 | E-01 (60-62行目) | ○ |
| C-03 | RankFeatureQueryBuilderをクエリとして登録 | E-01 (65-68行目) | ○ |
| C-04 | MapperPluginとSearchPluginを実装 | E-01 (46行目) | ○ |
| C-05 | ScaledFloatのCONTENT_TYPE | E-02 (確認済み) | ○ |
| C-06 | TokenCountのCONTENT_TYPE="token_count" | E-03 (55行目) | ○ |
| C-07 | TokenCountでanalyzerパラメータ定義 | E-03 (67行目) | ○ |
| C-08 | SearchAsYouTypeでShingleFilterとEdgeNGram | E-04 (import文 40-41行目) | ○ |
| C-09 | TokenCountでenable_position_increments設定 | E-03 (75-80行目) | ○ |
| C-10 | マッパーはコアモジュール同梱 | E-05 (modulesディレクトリ) | ○ |
| C-11 | カテゴリは「マッパー」 | E-05 | ○ |
| C-12 | ScaledFloatはParametrizedFieldMapperを継承 | E-02 (80行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 各マッパーの詳細なパラメータ仕様が正確か確認
- [ ] ScaledFloatの計算ロジック（scaling_factorの適用）が正確か確認
