---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：87-AnnotatedTextマッパー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/mapper-annotated-text/src/main/java/org/opensearch/index/mapper/annotatedtext/AnnotatedTextFieldMapper.java`
- E-02: `plugins/mapper-annotated-text/src/main/java/org/opensearch/plugin/mapper/AnnotatedTextPlugin.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 87行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CONTENT_TYPE="annotated_text" | E-01 (88行目) | ○ |
| C-02 | markdownPatternの正規表現 | E-01 (200行目) | ○ |
| C-03 | parse()でプレーンテキストとAnnotationTokenリスト生成 | E-01 (202-244行目) | ○ |
| C-04 | key=value形式でOpenSearchParseException | E-01 (223行目) | ○ |
| C-05 | URLDecoder.decodeでアノテーション値デコード | E-01 (229行目) | ○ |
| C-06 | AnnotationsInjectorがTokenFilterを継承 | E-01 (400行目) | ○ |
| C-07 | typeAtt.setType("annotation") | E-01 (496行目) | ○ |
| C-08 | indexOptionsがNONEでIllegalArgumentException | E-01 (173-175行目) | ○ |
| C-09 | position_increment_gap負数でMapperParsingException | E-01 (112-114行目) | ○ |
| C-10 | AnnotatedTextPlugin.getMappers()で登録 | E-02 (50行目) | ○ |
| C-11 | AnnotatedTextHighlighterを登録 | E-02 (55行目) | ○ |
| C-12 | TextFieldMapperのコードコピーに基づく実装 | E-01 (83-84行目コメント) | ○ |
| C-13 | AnnotatedHighlighterAnalyzerが存在 | E-01 (324-354行目) | ○ |
| C-14 | カテゴリは「マッパー」 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] AnnotationsInjectorのトークン注入ロジック（位置増分の処理）が正確に記述されているか確認
- [ ] マークダウン構文の制約事項が完全に記載されているか確認
