---
generated_at: 2026-02-03 10:35:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-Murmur3マッパー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/mapper-murmur3/src/main/java/org/opensearch/index/mapper/murmur3/Murmur3FieldMapper.java`
- E-02: `plugins/mapper-murmur3/src/main/java/org/opensearch/plugin/mapper/MapperMurmur3Plugin.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 88行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CONTENT_TYPE="murmur3" | E-01 (64行目) | ○ |
| C-02 | IndexOptions.NONE | E-01 (69行目) | ○ |
| C-03 | termQueryでQueryShardException | E-01 (128-130行目) | ○ |
| C-04 | SortedNumericIndexFieldDataを返す | E-01 (118-119行目) | ○ |
| C-05 | parseCreateFieldで値取得 | E-01 (149-154行目) | ○ |
| C-06 | BytesRefに変換 | E-01 (156行目) | ○ |
| C-07 | MurmurHash3.hash128でh1取得 | E-01 (157行目) | ○ |
| C-08 | SortedNumericDocValuesField追加 | E-01 (158行目) | ○ |
| C-09 | store時にStoredField追加 | E-01 (159-161行目) | ○ |
| C-10 | null値でスキップ | E-01 (155行目, if value != null) | ○ |
| C-11 | storedとmetaの2パラメータ | E-01 (80-81行目) | ○ |
| C-12 | カテゴリは「マッパー」 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] MurmurHash3のハッシュ計算が正確に記述されているか確認
- [ ] cardinality集計との連携が正確か確認
