---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 11
  claims_with_evidence: 11
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：89-Sizeマッパー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：11 / 11、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/mapper-size/src/main/java/org/opensearch/index/mapper/size/SizeFieldMapper.java`
- E-02: `plugins/mapper-size/src/main/java/org/opensearch/plugin/mapper/MapperSizePlugin.java`
- E-03: `docs/code-to-docs/機能一覧/機能一覧.csv` 89行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NAME="_size" | E-01 (49行目) | ○ |
| C-02 | MetadataFieldMapperを継承 | E-01 (48行目) | ○ |
| C-03 | デフォルトenabled=false | E-01 (57行目, 75行目) | ○ |
| C-04 | NumberFieldType(NAME, NumberType.INTEGER) | E-01 (70行目, 75行目) | ○ |
| C-05 | postParseで実行 | E-01 (96行目) | ○ |
| C-06 | enabled=falseで即return | E-01 (98-99行目) | ○ |
| C-07 | source().length()でバイト長取得 | E-01 (101行目) | ○ |
| C-08 | NumberType.INTEGER.createFieldsで格納 | E-01 (102行目) | ○ |
| C-09 | createFieldsの引数(indexed=true, docValues=true, stored=false, hasPoints=true) | E-01 (102行目) | ○ |
| C-10 | updateableBoolParamでenabled設定 | E-01 (57行目) | ○ |
| C-11 | ConfigurableTypeParserを使用 | E-01 (74-77行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全主張にソースコード根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] postParseのタイミング（_source圧縮との関係）が正確か確認
- [ ] createFieldsの引数フラグが正確か確認
