---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-インデックスビュー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. 特になし（全主張に根拠あり）
- 備考：本機能は @ExperimentalApi のため、View.javaのメタデータモデル側の確認を推奨

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/action/admin/indices/view/ViewService.java`
- E-02: `server/src/main/java/org/opensearch/action/admin/indices/view/CreateViewAction.java`
- E-03: `server/src/main/java/org/opensearch/action/admin/indices/view/GetViewAction.java`
- E-04: `server/src/main/java/org/opensearch/action/admin/indices/view/DeleteViewAction.java`
- E-05: `server/src/main/java/org/opensearch/action/admin/indices/view/UpdateViewAction.java`
- E-06: `server/src/main/java/org/opensearch/action/admin/indices/view/SearchViewAction.java`
- E-07: `server/src/main/java/org/opensearch/action/admin/indices/view/ListViewNamesAction.java`
- E-08: `server/src/main/java/org/opensearch/action/admin/indices/view/ViewAlreadyExistsException.java`
- E-09: `server/src/main/java/org/opensearch/action/admin/indices/view/ViewNotFoundException.java`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | アクション名はcluster:admin/views/create | E-02 (53行目) | ○ |
| C-02 | MAX_NAME_LENGTH=64 | E-02 (47行目) | ○ |
| C-03 | MAX_DESCRIPTION_LENGTH=256 | E-02 (48行目) | ○ |
| C-04 | MAX_TARGET_COUNT=25 | E-02 (49行目) | ○ |
| C-05 | MAX_TARGET_INDEX_PATTERN_LENGTH=64 | E-02 (50行目) | ○ |
| C-06 | 作成時にMETADATA_WRITEグローバルブロックチェック | E-02 (275-276行目) | ○ |
| C-07 | 取得時にMETADATA_READグローバルブロックチェック | E-03 (210-211行目) | ○ |
| C-08 | 作成時はallowOverriding=false（同名ビュー存在チェック） | E-01 (141行目, 157行目) | ○ |
| C-09 | 更新時はallowOverriding=true | E-01 (142行目) | ○ |
| C-10 | 更新時にcreatedAtを保持しmodifiedAtのみ更新 | E-01 (61-73行目) | ○ |
| C-11 | ビュー検索でScrollは使用不可 | E-06 (84-85行目) | ○ |
| C-12 | ビュー検索はSearchAction.INSTANCEに委譲 | E-01 (128行目) | ○ |
| C-13 | ビュー取得時にViewNotFoundExceptionをスロー | E-01 (137行目), E-09 (19行目) | ○ |
| C-14 | ビュー重複作成時にViewAlreadyExistsExceptionをスロー | E-01 (158行目), E-08 (19行目) | ○ |
| C-15 | ListViewNamesはHandledTransportAction | E-07 (116行目) | ○ |
| C-16 | SearchViewはHandledTransportAction | E-06 (113行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- View.javaのメタデータモデル（フィールド定義、シリアライゼーション）は未精査
  - 候補：`server/src/main/java/org/opensearch/cluster/metadata/View.java`
- REST APIのエンドポイント定義（RestActionクラス）は未精査

## 5) リスクフラグ（レビュー観点）
- 1: 低リスク -- @ExperimentalApiのため将来的な変更の可能性がある（機能的な正確性とは別のリスク）

## 6) レビュアーチェックリスト（最小）
- [ ] View.javaのメタデータモデルが設計書の出力仕様と一致するか確認
- [ ] REST APIエンドポイントの定義を確認
- [ ] @ExperimentalApiの制約事項を確認
